// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticsearchservice

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.elasticsearchservice.auth.ElasticsearchAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.elasticsearchservice.auth.ElasticsearchIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.elasticsearchservice.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.elasticsearchservice.model.*
import aws.sdk.kotlin.services.elasticsearchservice.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultElasticsearchClient(override val config: ElasticsearchClient.Config) : ElasticsearchClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ElasticsearchIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "es")
        }
        toMap()
    }
    private val authSchemeAdapter = ElasticsearchAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.elasticsearchservice"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     */
    override suspend fun acceptInboundCrossClusterSearchConnection(input: AcceptInboundCrossClusterSearchConnectionRequest): AcceptInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<AcceptInboundCrossClusterSearchConnectionRequest, AcceptInboundCrossClusterSearchConnectionResponse> {
            serializeWith = AcceptInboundCrossClusterSearchConnectionOperationSerializer()
            deserializeWith = AcceptInboundCrossClusterSearchConnectionOperationDeserializer()
            operationName = "AcceptInboundCrossClusterSearchConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See [ Tagging Amazon Elasticsearch Service Domains for more information.](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializeWith = AddTagsOperationSerializer()
            deserializeWith = AddTagsOperationDeserializer()
            operationName = "AddTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a package with an Amazon ES domain.
     */
    override suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse {
        val op = SdkHttpOperation.build<AssociatePackageRequest, AssociatePackageResponse> {
            serializeWith = AssociatePackageOperationSerializer()
            deserializeWith = AssociatePackageOperationDeserializer()
            operationName = "AssociatePackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    override suspend fun authorizeVpcEndpointAccess(input: AuthorizeVpcEndpointAccessRequest): AuthorizeVpcEndpointAccessResponse {
        val op = SdkHttpOperation.build<AuthorizeVpcEndpointAccessRequest, AuthorizeVpcEndpointAccessResponse> {
            serializeWith = AuthorizeVpcEndpointAccessOperationSerializer()
            deserializeWith = AuthorizeVpcEndpointAccessOperationDeserializer()
            operationName = "AuthorizeVpcEndpointAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a pending configuration change on an Amazon OpenSearch Service domain.
     */
    override suspend fun cancelDomainConfigChange(input: CancelDomainConfigChangeRequest): CancelDomainConfigChangeResponse {
        val op = SdkHttpOperation.build<CancelDomainConfigChangeRequest, CancelDomainConfigChangeResponse> {
            serializeWith = CancelDomainConfigChangeOperationSerializer()
            deserializeWith = CancelDomainConfigChangeOperationDeserializer()
            operationName = "CancelDomainConfigChange"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    override suspend fun cancelElasticsearchServiceSoftwareUpdate(input: CancelElasticsearchServiceSoftwareUpdateRequest): CancelElasticsearchServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<CancelElasticsearchServiceSoftwareUpdateRequest, CancelElasticsearchServiceSoftwareUpdateResponse> {
            serializeWith = CancelElasticsearchServiceSoftwareUpdateOperationSerializer()
            deserializeWith = CancelElasticsearchServiceSoftwareUpdateOperationDeserializer()
            operationName = "CancelElasticsearchServiceSoftwareUpdate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Elasticsearch domain. For more information, see [Creating Elasticsearch Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains) in the *Amazon Elasticsearch Service Developer Guide*.
     */
    override suspend fun createElasticsearchDomain(input: CreateElasticsearchDomainRequest): CreateElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<CreateElasticsearchDomainRequest, CreateElasticsearchDomainResponse> {
            serializeWith = CreateElasticsearchDomainOperationSerializer()
            deserializeWith = CreateElasticsearchDomainOperationDeserializer()
            operationName = "CreateElasticsearchDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     */
    override suspend fun createOutboundCrossClusterSearchConnection(input: CreateOutboundCrossClusterSearchConnectionRequest): CreateOutboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<CreateOutboundCrossClusterSearchConnectionRequest, CreateOutboundCrossClusterSearchConnectionResponse> {
            serializeWith = CreateOutboundCrossClusterSearchConnectionOperationSerializer()
            deserializeWith = CreateOutboundCrossClusterSearchConnectionOperationDeserializer()
            operationName = "CreateOutboundCrossClusterSearchConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Create a package for use with Amazon ES domains.
     */
    override suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse {
        val op = SdkHttpOperation.build<CreatePackageRequest, CreatePackageResponse> {
            serializeWith = CreatePackageOperationSerializer()
            deserializeWith = CreatePackageOperationDeserializer()
            operationName = "CreatePackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     */
    override suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse {
        val op = SdkHttpOperation.build<CreateVpcEndpointRequest, CreateVpcEndpointResponse> {
            serializeWith = CreateVpcEndpointOperationSerializer()
            deserializeWith = CreateVpcEndpointOperationDeserializer()
            operationName = "CreateVpcEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    override suspend fun deleteElasticsearchDomain(input: DeleteElasticsearchDomainRequest): DeleteElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<DeleteElasticsearchDomainRequest, DeleteElasticsearchDomainResponse> {
            serializeWith = DeleteElasticsearchDomainOperationSerializer()
            deserializeWith = DeleteElasticsearchDomainOperationDeserializer()
            operationName = "DeleteElasticsearchDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See [Deleting Elasticsearch Service Role](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr) in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
     */
    override suspend fun deleteElasticsearchServiceRole(input: DeleteElasticsearchServiceRoleRequest): DeleteElasticsearchServiceRoleResponse {
        val op = SdkHttpOperation.build<DeleteElasticsearchServiceRoleRequest, DeleteElasticsearchServiceRoleResponse> {
            serializeWith = DeleteElasticsearchServiceRoleOperationSerializer()
            deserializeWith = DeleteElasticsearchServiceRoleOperationDeserializer()
            operationName = "DeleteElasticsearchServiceRole"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     */
    override suspend fun deleteInboundCrossClusterSearchConnection(input: DeleteInboundCrossClusterSearchConnectionRequest): DeleteInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<DeleteInboundCrossClusterSearchConnectionRequest, DeleteInboundCrossClusterSearchConnectionResponse> {
            serializeWith = DeleteInboundCrossClusterSearchConnectionOperationSerializer()
            deserializeWith = DeleteInboundCrossClusterSearchConnectionOperationDeserializer()
            operationName = "DeleteInboundCrossClusterSearchConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     */
    override suspend fun deleteOutboundCrossClusterSearchConnection(input: DeleteOutboundCrossClusterSearchConnectionRequest): DeleteOutboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<DeleteOutboundCrossClusterSearchConnectionRequest, DeleteOutboundCrossClusterSearchConnectionResponse> {
            serializeWith = DeleteOutboundCrossClusterSearchConnectionOperationSerializer()
            deserializeWith = DeleteOutboundCrossClusterSearchConnectionOperationDeserializer()
            operationName = "DeleteOutboundCrossClusterSearchConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete the package.
     */
    override suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse {
        val op = SdkHttpOperation.build<DeletePackageRequest, DeletePackageResponse> {
            serializeWith = DeletePackageOperationSerializer()
            deserializeWith = DeletePackageOperationDeserializer()
            operationName = "DeletePackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    override suspend fun deleteVpcEndpoint(input: DeleteVpcEndpointRequest): DeleteVpcEndpointResponse {
        val op = SdkHttpOperation.build<DeleteVpcEndpointRequest, DeleteVpcEndpointResponse> {
            serializeWith = DeleteVpcEndpointOperationSerializer()
            deserializeWith = DeleteVpcEndpointOperationDeserializer()
            operationName = "DeleteVpcEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    override suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse {
        val op = SdkHttpOperation.build<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse> {
            serializeWith = DescribeDomainAutoTunesOperationSerializer()
            deserializeWith = DescribeDomainAutoTunesOperationDeserializer()
            operationName = "DescribeDomainAutoTunes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    override suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse {
        val op = SdkHttpOperation.build<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResponse> {
            serializeWith = DescribeDomainChangeProgressOperationSerializer()
            deserializeWith = DescribeDomainChangeProgressOperationDeserializer()
            operationName = "DescribeDomainChangeProgress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeElasticsearchDomain(input: DescribeElasticsearchDomainRequest): DescribeElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainRequest, DescribeElasticsearchDomainResponse> {
            serializeWith = DescribeElasticsearchDomainOperationSerializer()
            deserializeWith = DescribeElasticsearchDomainOperationDeserializer()
            operationName = "DescribeElasticsearchDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
     */
    override suspend fun describeElasticsearchDomainConfig(input: DescribeElasticsearchDomainConfigRequest): DescribeElasticsearchDomainConfigResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainConfigRequest, DescribeElasticsearchDomainConfigResponse> {
            serializeWith = DescribeElasticsearchDomainConfigOperationSerializer()
            deserializeWith = DescribeElasticsearchDomainConfigOperationDeserializer()
            operationName = "DescribeElasticsearchDomainConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeElasticsearchDomains(input: DescribeElasticsearchDomainsRequest): DescribeElasticsearchDomainsResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchDomainsRequest, DescribeElasticsearchDomainsResponse> {
            serializeWith = DescribeElasticsearchDomainsOperationSerializer()
            deserializeWith = DescribeElasticsearchDomainsOperationDeserializer()
            operationName = "DescribeElasticsearchDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the ` <a>DomainName</a> ` to know what Limits are supported for modifying.
     */
    override suspend fun describeElasticsearchInstanceTypeLimits(input: DescribeElasticsearchInstanceTypeLimitsRequest): DescribeElasticsearchInstanceTypeLimitsResponse {
        val op = SdkHttpOperation.build<DescribeElasticsearchInstanceTypeLimitsRequest, DescribeElasticsearchInstanceTypeLimitsResponse> {
            serializeWith = DescribeElasticsearchInstanceTypeLimitsOperationSerializer()
            deserializeWith = DescribeElasticsearchInstanceTypeLimitsOperationDeserializer()
            operationName = "DescribeElasticsearchInstanceTypeLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the inbound cross-cluster search connections for a destination domain.
     */
    override suspend fun describeInboundCrossClusterSearchConnections(input: DescribeInboundCrossClusterSearchConnectionsRequest): DescribeInboundCrossClusterSearchConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeInboundCrossClusterSearchConnectionsRequest, DescribeInboundCrossClusterSearchConnectionsResponse> {
            serializeWith = DescribeInboundCrossClusterSearchConnectionsOperationSerializer()
            deserializeWith = DescribeInboundCrossClusterSearchConnectionsOperationDeserializer()
            operationName = "DescribeInboundCrossClusterSearchConnections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the outbound cross-cluster search connections for a source domain.
     */
    override suspend fun describeOutboundCrossClusterSearchConnections(input: DescribeOutboundCrossClusterSearchConnectionsRequest): DescribeOutboundCrossClusterSearchConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeOutboundCrossClusterSearchConnectionsRequest, DescribeOutboundCrossClusterSearchConnectionsResponse> {
            serializeWith = DescribeOutboundCrossClusterSearchConnectionsOperationSerializer()
            deserializeWith = DescribeOutboundCrossClusterSearchConnectionsOperationDeserializer()
            operationName = "DescribeOutboundCrossClusterSearchConnections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
     */
    override suspend fun describePackages(input: DescribePackagesRequest): DescribePackagesResponse {
        val op = SdkHttpOperation.build<DescribePackagesRequest, DescribePackagesResponse> {
            serializeWith = DescribePackagesOperationSerializer()
            deserializeWith = DescribePackagesOperationDeserializer()
            operationName = "DescribePackages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists available reserved Elasticsearch instance offerings.
     */
    override suspend fun describeReservedElasticsearchInstanceOfferings(input: DescribeReservedElasticsearchInstanceOfferingsRequest): DescribeReservedElasticsearchInstanceOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedElasticsearchInstanceOfferingsRequest, DescribeReservedElasticsearchInstanceOfferingsResponse> {
            serializeWith = DescribeReservedElasticsearchInstanceOfferingsOperationSerializer()
            deserializeWith = DescribeReservedElasticsearchInstanceOfferingsOperationDeserializer()
            operationName = "DescribeReservedElasticsearchInstanceOfferings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about reserved Elasticsearch instances for this account.
     */
    override suspend fun describeReservedElasticsearchInstances(input: DescribeReservedElasticsearchInstancesRequest): DescribeReservedElasticsearchInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReservedElasticsearchInstancesRequest, DescribeReservedElasticsearchInstancesResponse> {
            serializeWith = DescribeReservedElasticsearchInstancesOperationSerializer()
            deserializeWith = DescribeReservedElasticsearchInstancesOperationDeserializer()
            operationName = "DescribeReservedElasticsearchInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     */
    override suspend fun describeVpcEndpoints(input: DescribeVpcEndpointsRequest): DescribeVpcEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResponse> {
            serializeWith = DescribeVpcEndpointsOperationSerializer()
            deserializeWith = DescribeVpcEndpointsOperationDeserializer()
            operationName = "DescribeVpcEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Dissociates a package from the Amazon ES domain.
     */
    override suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse {
        val op = SdkHttpOperation.build<DissociatePackageRequest, DissociatePackageResponse> {
            serializeWith = DissociatePackageOperationSerializer()
            deserializeWith = DissociatePackageOperationDeserializer()
            operationName = "DissociatePackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade compatible Elasticsearch versions for that specific domain.
     */
    override suspend fun getCompatibleElasticsearchVersions(input: GetCompatibleElasticsearchVersionsRequest): GetCompatibleElasticsearchVersionsResponse {
        val op = SdkHttpOperation.build<GetCompatibleElasticsearchVersionsRequest, GetCompatibleElasticsearchVersionsResponse> {
            serializeWith = GetCompatibleElasticsearchVersionsOperationSerializer()
            deserializeWith = GetCompatibleElasticsearchVersionsOperationDeserializer()
            operationName = "GetCompatibleElasticsearchVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of versions of the package, along with their creation time and commit message.
     */
    override suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse {
        val op = SdkHttpOperation.build<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse> {
            serializeWith = GetPackageVersionHistoryOperationSerializer()
            deserializeWith = GetPackageVersionHistoryOperationDeserializer()
            operationName = "GetPackageVersionHistory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     */
    override suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse {
        val op = SdkHttpOperation.build<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse> {
            serializeWith = GetUpgradeHistoryOperationSerializer()
            deserializeWith = GetUpgradeHistoryOperationDeserializer()
            operationName = "GetUpgradeHistory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     */
    override suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse {
        val op = SdkHttpOperation.build<GetUpgradeStatusRequest, GetUpgradeStatusResponse> {
            serializeWith = GetUpgradeStatusOperationSerializer()
            deserializeWith = GetUpgradeStatusOperationDeserializer()
            operationName = "GetUpgradeStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializeWith = ListDomainNamesOperationSerializer()
            deserializeWith = ListDomainNamesOperationDeserializer()
            operationName = "ListDomainNames"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon ES domains associated with the package.
     */
    override suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse {
        val op = SdkHttpOperation.build<ListDomainsForPackageRequest, ListDomainsForPackageResponse> {
            serializeWith = ListDomainsForPackageOperationSerializer()
            deserializeWith = ListDomainsForPackageOperationDeserializer()
            operationName = "ListDomainsForPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     */
    override suspend fun listElasticsearchInstanceTypes(input: ListElasticsearchInstanceTypesRequest): ListElasticsearchInstanceTypesResponse {
        val op = SdkHttpOperation.build<ListElasticsearchInstanceTypesRequest, ListElasticsearchInstanceTypesResponse> {
            serializeWith = ListElasticsearchInstanceTypesOperationSerializer()
            deserializeWith = ListElasticsearchInstanceTypesOperationDeserializer()
            operationName = "ListElasticsearchInstanceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all supported Elasticsearch versions
     */
    override suspend fun listElasticsearchVersions(input: ListElasticsearchVersionsRequest): ListElasticsearchVersionsResponse {
        val op = SdkHttpOperation.build<ListElasticsearchVersionsRequest, ListElasticsearchVersionsResponse> {
            serializeWith = ListElasticsearchVersionsOperationSerializer()
            deserializeWith = ListElasticsearchVersionsOperationDeserializer()
            operationName = "ListElasticsearchVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all packages associated with the Amazon ES domain.
     */
    override suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse {
        val op = SdkHttpOperation.build<ListPackagesForDomainRequest, ListPackagesForDomainResponse> {
            serializeWith = ListPackagesForDomainOperationSerializer()
            deserializeWith = ListPackagesForDomainOperationDeserializer()
            operationName = "ListPackagesForDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all tags for the given Elasticsearch domain.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializeWith = ListTagsOperationSerializer()
            deserializeWith = ListTagsOperationDeserializer()
            operationName = "ListTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     */
    override suspend fun listVpcEndpointAccess(input: ListVpcEndpointAccessRequest): ListVpcEndpointAccessResponse {
        val op = SdkHttpOperation.build<ListVpcEndpointAccessRequest, ListVpcEndpointAccessResponse> {
            serializeWith = ListVpcEndpointAccessOperationSerializer()
            deserializeWith = ListVpcEndpointAccessOperationDeserializer()
            operationName = "ListVpcEndpointAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
     */
    override suspend fun listVpcEndpoints(input: ListVpcEndpointsRequest): ListVpcEndpointsResponse {
        val op = SdkHttpOperation.build<ListVpcEndpointsRequest, ListVpcEndpointsResponse> {
            serializeWith = ListVpcEndpointsOperationSerializer()
            deserializeWith = ListVpcEndpointsOperationDeserializer()
            operationName = "ListVpcEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     */
    override suspend fun listVpcEndpointsForDomain(input: ListVpcEndpointsForDomainRequest): ListVpcEndpointsForDomainResponse {
        val op = SdkHttpOperation.build<ListVpcEndpointsForDomainRequest, ListVpcEndpointsForDomainResponse> {
            serializeWith = ListVpcEndpointsForDomainOperationSerializer()
            deserializeWith = ListVpcEndpointsForDomainOperationDeserializer()
            operationName = "ListVpcEndpointsForDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to purchase reserved Elasticsearch instances.
     */
    override suspend fun purchaseReservedElasticsearchInstanceOffering(input: PurchaseReservedElasticsearchInstanceOfferingRequest): PurchaseReservedElasticsearchInstanceOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedElasticsearchInstanceOfferingRequest, PurchaseReservedElasticsearchInstanceOfferingResponse> {
            serializeWith = PurchaseReservedElasticsearchInstanceOfferingOperationSerializer()
            deserializeWith = PurchaseReservedElasticsearchInstanceOfferingOperationDeserializer()
            operationName = "PurchaseReservedElasticsearchInstanceOffering"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     */
    override suspend fun rejectInboundCrossClusterSearchConnection(input: RejectInboundCrossClusterSearchConnectionRequest): RejectInboundCrossClusterSearchConnectionResponse {
        val op = SdkHttpOperation.build<RejectInboundCrossClusterSearchConnectionRequest, RejectInboundCrossClusterSearchConnectionResponse> {
            serializeWith = RejectInboundCrossClusterSearchConnectionOperationSerializer()
            deserializeWith = RejectInboundCrossClusterSearchConnectionOperationDeserializer()
            operationName = "RejectInboundCrossClusterSearchConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified set of tags from the specified Elasticsearch domain.
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializeWith = RemoveTagsOperationSerializer()
            deserializeWith = RemoveTagsOperationDeserializer()
            operationName = "RemoveTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     */
    override suspend fun revokeVpcEndpointAccess(input: RevokeVpcEndpointAccessRequest): RevokeVpcEndpointAccessResponse {
        val op = SdkHttpOperation.build<RevokeVpcEndpointAccessRequest, RevokeVpcEndpointAccessResponse> {
            serializeWith = RevokeVpcEndpointAccessOperationSerializer()
            deserializeWith = RevokeVpcEndpointAccessOperationDeserializer()
            operationName = "RevokeVpcEndpointAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Schedules a service software update for an Amazon ES domain.
     */
    override suspend fun startElasticsearchServiceSoftwareUpdate(input: StartElasticsearchServiceSoftwareUpdateRequest): StartElasticsearchServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<StartElasticsearchServiceSoftwareUpdateRequest, StartElasticsearchServiceSoftwareUpdateResponse> {
            serializeWith = StartElasticsearchServiceSoftwareUpdateOperationSerializer()
            deserializeWith = StartElasticsearchServiceSoftwareUpdateOperationDeserializer()
            operationName = "StartElasticsearchServiceSoftwareUpdate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
     */
    override suspend fun updateElasticsearchDomainConfig(input: UpdateElasticsearchDomainConfigRequest): UpdateElasticsearchDomainConfigResponse {
        val op = SdkHttpOperation.build<UpdateElasticsearchDomainConfigRequest, UpdateElasticsearchDomainConfigResponse> {
            serializeWith = UpdateElasticsearchDomainConfigOperationSerializer()
            deserializeWith = UpdateElasticsearchDomainConfigOperationDeserializer()
            operationName = "UpdateElasticsearchDomainConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a package for use with Amazon ES domains.
     */
    override suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse {
        val op = SdkHttpOperation.build<UpdatePackageRequest, UpdatePackageResponse> {
            serializeWith = UpdatePackageOperationSerializer()
            deserializeWith = UpdatePackageOperationDeserializer()
            operationName = "UpdatePackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     */
    override suspend fun updateVpcEndpoint(input: UpdateVpcEndpointRequest): UpdateVpcEndpointResponse {
        val op = SdkHttpOperation.build<UpdateVpcEndpointRequest, UpdateVpcEndpointResponse> {
            serializeWith = UpdateVpcEndpointOperationSerializer()
            deserializeWith = UpdateVpcEndpointOperationDeserializer()
            operationName = "UpdateVpcEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
     */
    override suspend fun upgradeElasticsearchDomain(input: UpgradeElasticsearchDomainRequest): UpgradeElasticsearchDomainResponse {
        val op = SdkHttpOperation.build<UpgradeElasticsearchDomainRequest, UpgradeElasticsearchDomainResponse> {
            serializeWith = UpgradeElasticsearchDomainOperationSerializer()
            deserializeWith = UpgradeElasticsearchDomainOperationDeserializer()
            operationName = "UpgradeElasticsearchDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "es")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
