// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AvailabilityZone
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class SetSubnetsOperationDeserializer: HttpDeserializer.NonStreaming<SetSubnetsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SetSubnetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetSubnetsError(context, call, payload)
        }
        val builder = SetSubnetsResponse.Builder()

        if (payload != null) {
            deserializeSetSubnetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSetSubnetsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AvailabilityZoneNotSupported" -> AvailabilityZoneNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AllocationIdNotFound" -> AllocationIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SubnetNotFound" -> SubnetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LoadBalancerNotFound" -> LoadBalancerNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetSubnetsOperationBody(builder: SetSubnetsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "SetSubnets")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AvailabilityZones com.amazonaws.elasticloadbalancingv2#SetSubnetsOutput$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // IpAddressType com.amazonaws.elasticloadbalancingv2#SetSubnetsOutput$IpAddressType
            "IpAddressType" -> builder.ipAddressType = curr.tryData()
                .parse { IpAddressType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticloadbalancingv2#IpAddressType`)" }
            else -> {}
        }
        curr.drop()
    }
}
