// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class SetSecurityGroupsOperationDeserializer: HttpDeserializer.NonStreaming<SetSecurityGroupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SetSecurityGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetSecurityGroupsError(context, call, payload)
        }
        val builder = SetSecurityGroupsResponse.Builder()

        if (payload != null) {
            deserializeSetSecurityGroupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSetSecurityGroupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LoadBalancerNotFound" -> LoadBalancerNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurityGroup" -> InvalidSecurityGroupExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetSecurityGroupsOperationBody(builder: SetSecurityGroupsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "SetSecurityGroups")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic com.amazonaws.elasticloadbalancingv2#SetSecurityGroupsOutput$EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic
            "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic" -> builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = curr.tryData()
                .parse { EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticloadbalancingv2#EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum`)" }
            // SecurityGroupIds com.amazonaws.elasticloadbalancingv2#SetSecurityGroupsOutput$SecurityGroupIds
            "SecurityGroupIds" -> builder.securityGroupIds = deserializeSecurityGroupsShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
