// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Rule
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class SetRulePrioritiesOperationDeserializer: HttpDeserializer.NonStreaming<SetRulePrioritiesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SetRulePrioritiesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetRulePrioritiesError(context, call, payload)
        }
        val builder = SetRulePrioritiesResponse.Builder()

        if (payload != null) {
            deserializeSetRulePrioritiesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSetRulePrioritiesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RuleNotFound" -> RuleNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PriorityInUse" -> PriorityInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermitted" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetRulePrioritiesOperationBody(builder: SetRulePrioritiesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "SetRulePriorities")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Rules com.amazonaws.elasticloadbalancingv2#SetRulePrioritiesOutput$Rules
            "Rules" -> builder.rules = deserializeRulesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
