// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTrustStoreResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.TrustStore
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyTrustStoreOperationDeserializer: HttpDeserializer.NonStreaming<ModifyTrustStoreResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyTrustStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyTrustStoreError(context, call, payload)
        }
        val builder = ModifyTrustStoreResponse.Builder()

        if (payload != null) {
            deserializeModifyTrustStoreOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyTrustStoreError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidCaCertificatesBundle" -> InvalidCaCertificatesBundleExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CaCertificatesBundleNotFound" -> CaCertificatesBundleNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrustStoreNotFound" -> TrustStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyTrustStoreOperationBody(builder: ModifyTrustStoreResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyTrustStore")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // TrustStores com.amazonaws.elasticloadbalancingv2#ModifyTrustStoreOutput$TrustStores
            "TrustStores" -> builder.trustStores = deserializeTrustStoresShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
