// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeLoadBalancerDocument(reader: XmlTagReader): LoadBalancer {
    val builder = LoadBalancer.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // LoadBalancerArn com.amazonaws.elasticloadbalancingv2#LoadBalancer$LoadBalancerArn
            "LoadBalancerArn" -> builder.loadBalancerArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#LoadBalancerArn`)" }
            // DNSName com.amazonaws.elasticloadbalancingv2#LoadBalancer$DNSName
            "DNSName" -> builder.dnsName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#DNSName`)" }
            // CanonicalHostedZoneId com.amazonaws.elasticloadbalancingv2#LoadBalancer$CanonicalHostedZoneId
            "CanonicalHostedZoneId" -> builder.canonicalHostedZoneId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#CanonicalHostedZoneId`)" }
            // CreatedTime com.amazonaws.elasticloadbalancingv2#LoadBalancer$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticloadbalancingv2#CreatedTime`)" }
            // LoadBalancerName com.amazonaws.elasticloadbalancingv2#LoadBalancer$LoadBalancerName
            "LoadBalancerName" -> builder.loadBalancerName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#LoadBalancerName`)" }
            // Scheme com.amazonaws.elasticloadbalancingv2#LoadBalancer$Scheme
            "Scheme" -> builder.scheme = curr.tryData()
                .parse { LoadBalancerSchemeEnum.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticloadbalancingv2#LoadBalancerSchemeEnum`)" }
            // VpcId com.amazonaws.elasticloadbalancingv2#LoadBalancer$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#VpcId`)" }
            // State com.amazonaws.elasticloadbalancingv2#LoadBalancer$State
            "State" -> builder.state = deserializeLoadBalancerStateDocument(curr)
            // Type com.amazonaws.elasticloadbalancingv2#LoadBalancer$Type
            "Type" -> builder.type = curr.tryData()
                .parse { LoadBalancerTypeEnum.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticloadbalancingv2#LoadBalancerTypeEnum`)" }
            // AvailabilityZones com.amazonaws.elasticloadbalancingv2#LoadBalancer$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // SecurityGroups com.amazonaws.elasticloadbalancingv2#LoadBalancer$SecurityGroups
            "SecurityGroups" -> builder.securityGroups = deserializeSecurityGroupsShape(curr)
            // IpAddressType com.amazonaws.elasticloadbalancingv2#LoadBalancer$IpAddressType
            "IpAddressType" -> builder.ipAddressType = curr.tryData()
                .parse { IpAddressType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticloadbalancingv2#IpAddressType`)" }
            // CustomerOwnedIpv4Pool com.amazonaws.elasticloadbalancingv2#LoadBalancer$CustomerOwnedIpv4Pool
            "CustomerOwnedIpv4Pool" -> builder.customerOwnedIpv4Pool = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#CustomerOwnedIpv4Pool`)" }
            // EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic com.amazonaws.elasticloadbalancingv2#LoadBalancer$EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic
            "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic" -> builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
