// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetTrustStoreRevocationContentOperationDeserializer: HttpDeserializer.NonStreaming<GetTrustStoreRevocationContentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTrustStoreRevocationContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTrustStoreRevocationContentError(context, call, payload)
        }
        val builder = GetTrustStoreRevocationContentResponse.Builder()

        if (payload != null) {
            deserializeGetTrustStoreRevocationContentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTrustStoreRevocationContentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RevocationIdNotFound" -> RevocationIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrustStoreNotFound" -> TrustStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrustStoreRevocationContentOperationBody(builder: GetTrustStoreRevocationContentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetTrustStoreRevocationContent")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Location com.amazonaws.elasticloadbalancingv2#GetTrustStoreRevocationContentOutput$Location
            "Location" -> builder.location = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#Location`)" }
            else -> {}
        }
        curr.drop()
    }
}
