// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetResourcePolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetResourcePolicyOperationDeserializer: HttpDeserializer.NonStreaming<GetResourcePolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourcePolicyError(context, call, payload)
        }
        val builder = GetResourcePolicyResponse.Builder()

        if (payload != null) {
            deserializeGetResourcePolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetResourcePolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourcePolicyOperationBody(builder: GetResourcePolicyResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetResourcePolicy")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Policy com.amazonaws.elasticloadbalancingv2#GetResourcePolicyOutput$Policy
            "Policy" -> builder.policy = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#Policy`)" }
            else -> {}
        }
        curr.drop()
    }
}
