// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocation
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeTrustStoreRevocationsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTrustStoreRevocationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTrustStoreRevocationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrustStoreRevocationsError(context, call, payload)
        }
        val builder = DescribeTrustStoreRevocationsResponse.Builder()

        if (payload != null) {
            deserializeDescribeTrustStoreRevocationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTrustStoreRevocationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RevocationIdNotFound" -> RevocationIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrustStoreNotFound" -> TrustStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrustStoreRevocationsOperationBody(builder: DescribeTrustStoreRevocationsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeTrustStoreRevocations")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextMarker com.amazonaws.elasticloadbalancingv2#DescribeTrustStoreRevocationsOutput$NextMarker
            "NextMarker" -> builder.nextMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#Marker`)" }
            // TrustStoreRevocations com.amazonaws.elasticloadbalancingv2#DescribeTrustStoreRevocationsOutput$TrustStoreRevocations
            "TrustStoreRevocations" -> builder.trustStoreRevocations = deserializeDescribeTrustStoreRevocationResponseShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
