// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SslPolicy
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeSSLPoliciesOperationDeserializer: HttpDeserializer.NonStreaming<DescribeSslPoliciesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeSslPoliciesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSslPoliciesError(context, call, payload)
        }
        val builder = DescribeSslPoliciesResponse.Builder()

        if (payload != null) {
            deserializeDescribeSSLPoliciesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeSslPoliciesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SSLPolicyNotFound" -> SslPolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSSLPoliciesOperationBody(builder: DescribeSslPoliciesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeSSLPolicies")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextMarker com.amazonaws.elasticloadbalancingv2#DescribeSSLPoliciesOutput$NextMarker
            "NextMarker" -> builder.nextMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancingv2#Marker`)" }
            // SslPolicies com.amazonaws.elasticloadbalancingv2#DescribeSSLPoliciesOutput$SslPolicies
            "SslPolicies" -> builder.sslPolicies = deserializeSslPoliciesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
