// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Rule
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateRuleOperationDeserializer: HttpDeserializer.NonStreaming<CreateRuleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRuleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRuleError(context, call, payload)
        }
        val builder = CreateRuleResponse.Builder()

        if (payload != null) {
            deserializeCreateRuleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRuleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRegistrationsForTargetId" -> TooManyRegistrationsForTargetIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLoadBalancerAction" -> InvalidLoadBalancerActionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTargets" -> TooManyTargetsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyActions" -> TooManyActionsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTargetGroups" -> TooManyTargetGroupsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TargetGroupAssociationLimit" -> TargetGroupAssociationLimitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IncompatibleProtocols" -> IncompatibleProtocolsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PriorityInUse" -> PriorityInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyUniqueTargetGroupsPerLoadBalancer" -> TooManyUniqueTargetGroupsPerLoadBalancerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TargetGroupNotFound" -> TargetGroupNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRules" -> TooManyRulesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTags" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRuleOperationBody(builder: CreateRuleResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateRule")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Rules com.amazonaws.elasticloadbalancingv2#CreateRuleOutput$Rules
            "Rules" -> builder.rules = deserializeRulesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
