// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.TrustStoreRevocation
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AddTrustStoreRevocationsOperationDeserializer: HttpDeserializer.NonStreaming<AddTrustStoreRevocationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddTrustStoreRevocationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddTrustStoreRevocationsError(context, call, payload)
        }
        val builder = AddTrustStoreRevocationsResponse.Builder()

        if (payload != null) {
            deserializeAddTrustStoreRevocationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddTrustStoreRevocationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRevocationContent" -> InvalidRevocationContentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevocationContentNotFound" -> RevocationContentNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTrustStoreRevocationEntries" -> TooManyTrustStoreRevocationEntriesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrustStoreNotFound" -> TrustStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddTrustStoreRevocationsOperationBody(builder: AddTrustStoreRevocationsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AddTrustStoreRevocations")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // TrustStoreRevocations com.amazonaws.elasticloadbalancingv2#AddTrustStoreRevocationsOutput$TrustStoreRevocations
            "TrustStoreRevocations" -> builder.trustStoreRevocations = deserializeTrustStoreRevocationsShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
