// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Certificate
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AddListenerCertificatesOperationDeserializer: HttpDeserializer.NonStreaming<AddListenerCertificatesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddListenerCertificatesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddListenerCertificatesError(context, call, payload)
        }
        val builder = AddListenerCertificatesResponse.Builder()

        if (payload != null) {
            deserializeAddListenerCertificatesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddListenerCertificatesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCertificates" -> TooManyCertificatesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddListenerCertificatesOperationBody(builder: AddListenerCertificatesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AddListenerCertificates")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Certificates com.amazonaws.elasticloadbalancingv2#AddListenerCertificatesOutput$Certificates
            "Certificates" -> builder.certificates = deserializeCertificateListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
