// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.paginators

import aws.sdk.kotlin.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Certificate
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Rule
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeListenerCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeListenerCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenerCertificatesResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenerCertificatesPaginated(initialRequest: DescribeListenerCertificatesRequest): Flow<DescribeListenerCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeListenerCertificatesPaginated.describeListenerCertificates(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeListenerCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenerCertificatesResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenerCertificatesPaginated(block: DescribeListenerCertificatesRequest.Builder.() -> Unit): Flow<DescribeListenerCertificatesResponse> =
    describeListenerCertificatesPaginated(DescribeListenerCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeListenerCertificatesPaginated]
 * to access the nested member [Certificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Certificate]
 */
@JvmName("describeListenerCertificatesResponseCertificate")
public fun Flow<DescribeListenerCertificatesResponse>.certificates(): Flow<Certificate> =
    transform() { response ->
        response.certificates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenersPaginated(initialRequest: DescribeListenersRequest = DescribeListenersRequest { }): Flow<DescribeListenersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeListenersPaginated.describeListeners(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenersPaginated(block: DescribeListenersRequest.Builder.() -> Unit): Flow<DescribeListenersResponse> =
    describeListenersPaginated(DescribeListenersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeListenersPaginated]
 * to access the nested member [Listener]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Listener]
 */
@JvmName("describeListenersResponseListener")
public fun Flow<DescribeListenersResponse>.listeners(): Flow<Listener> =
    transform() { response ->
        response.listeners?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLoadBalancersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeLoadBalancersPaginated(initialRequest: DescribeLoadBalancersRequest = DescribeLoadBalancersRequest { }): Flow<DescribeLoadBalancersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeLoadBalancersPaginated.describeLoadBalancers(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeLoadBalancersPaginated(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Flow<DescribeLoadBalancersResponse> =
    describeLoadBalancersPaginated(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLoadBalancersPaginated]
 * to access the nested member [LoadBalancer]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LoadBalancer]
 */
@JvmName("describeLoadBalancersResponseLoadBalancer")
public fun Flow<DescribeLoadBalancersResponse>.loadBalancers(): Flow<LoadBalancer> =
    transform() { response ->
        response.loadBalancers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRulesResponse]
 */
public fun ElasticLoadBalancingV2Client.describeRulesPaginated(initialRequest: DescribeRulesRequest = DescribeRulesRequest { }): Flow<DescribeRulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeRulesPaginated.describeRules(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRulesResponse]
 */
public fun ElasticLoadBalancingV2Client.describeRulesPaginated(block: DescribeRulesRequest.Builder.() -> Unit): Flow<DescribeRulesResponse> =
    describeRulesPaginated(DescribeRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRulesPaginated]
 * to access the nested member [Rule]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Rule]
 */
@JvmName("describeRulesResponseRule")
public fun Flow<DescribeRulesResponse>.rules(): Flow<Rule> =
    transform() { response ->
        response.rules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTargetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTargetGroupsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTargetGroupsPaginated(initialRequest: DescribeTargetGroupsRequest = DescribeTargetGroupsRequest { }): Flow<DescribeTargetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTargetGroupsPaginated.describeTargetGroups(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTargetGroupsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTargetGroupsPaginated(block: DescribeTargetGroupsRequest.Builder.() -> Unit): Flow<DescribeTargetGroupsResponse> =
    describeTargetGroupsPaginated(DescribeTargetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTargetGroupsPaginated]
 * to access the nested member [TargetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TargetGroup]
 */
@JvmName("describeTargetGroupsResponseTargetGroup")
public fun Flow<DescribeTargetGroupsResponse>.targetGroups(): Flow<TargetGroup> =
    transform() { response ->
        response.targetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTrustStoreAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTrustStoreAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoreAssociationsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoreAssociationsPaginated(initialRequest: DescribeTrustStoreAssociationsRequest): Flow<DescribeTrustStoreAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTrustStoreAssociationsPaginated.describeTrustStoreAssociations(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTrustStoreAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoreAssociationsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoreAssociationsPaginated(block: DescribeTrustStoreAssociationsRequest.Builder.() -> Unit): Flow<DescribeTrustStoreAssociationsResponse> =
    describeTrustStoreAssociationsPaginated(DescribeTrustStoreAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeTrustStoreRevocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTrustStoreRevocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoreRevocationsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoreRevocationsPaginated(initialRequest: DescribeTrustStoreRevocationsRequest): Flow<DescribeTrustStoreRevocationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTrustStoreRevocationsPaginated.describeTrustStoreRevocations(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTrustStoreRevocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoreRevocationsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoreRevocationsPaginated(block: DescribeTrustStoreRevocationsRequest.Builder.() -> Unit): Flow<DescribeTrustStoreRevocationsResponse> =
    describeTrustStoreRevocationsPaginated(DescribeTrustStoreRevocationsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTrustStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoresResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoresPaginated(initialRequest: DescribeTrustStoresRequest = DescribeTrustStoresRequest { }): Flow<DescribeTrustStoresResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTrustStoresPaginated.describeTrustStores(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrustStoresResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTrustStoresPaginated(block: DescribeTrustStoresRequest.Builder.() -> Unit): Flow<DescribeTrustStoresResponse> =
    describeTrustStoresPaginated(DescribeTrustStoresRequest.Builder().apply(block).build())
