// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a target group.
 */
public class TargetGroup private constructor(builder: Builder) {
    /**
     * Indicates whether health checks are enabled.
     */
    public val healthCheckEnabled: kotlin.Boolean? = builder.healthCheckEnabled
    /**
     * The approximate amount of time, in seconds, between health checks of an individual target.
     */
    public val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * The destination for health checks on the targets.
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The port to use to connect with the target.
     */
    public val healthCheckPort: kotlin.String? = builder.healthCheckPort
    /**
     * The protocol to use to connect with the target. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    public val healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.healthCheckProtocol
    /**
     * The amount of time, in seconds, during which no response means a failed health check.
     */
    public val healthCheckTimeoutSeconds: kotlin.Int? = builder.healthCheckTimeoutSeconds
    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     */
    public val healthyThresholdCount: kotlin.Int? = builder.healthyThresholdCount
    /**
     * The type of IP address used for this target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum? = builder.ipAddressType
    /**
     * The Amazon Resource Name (ARN) of the load balancer that routes traffic to this target group. You can use each target group with only one load balancer.
     */
    public val loadBalancerArns: List<String>? = builder.loadBalancerArns
    /**
     * The HTTP or gRPC codes to use when checking for a successful response from a target.
     */
    public val matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = builder.matcher
    /**
     * The port on which the targets are listening. This parameter is not used if the target is a Lambda function.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for routing traffic to the targets.
     */
    public val protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.protocol
    /**
     * &#91;HTTP/HTTPS protocol&#93; The protocol version. The possible values are `GRPC`, `HTTP1`, and `HTTP2`.
     */
    public val protocolVersion: kotlin.String? = builder.protocolVersion
    /**
     * The Amazon Resource Name (ARN) of the target group.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn
    /**
     * The name of the target group.
     */
    public val targetGroupName: kotlin.String? = builder.targetGroupName
    /**
     * The type of target that you must specify when registering targets with this target group. The possible values are `instance` (register targets by instance ID), `ip` (register targets by IP address), `lambda` (register a single Lambda function as a target), or `alb` (register a single Application Load Balancer as a target).
     */
    public val targetType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetTypeEnum? = builder.targetType
    /**
     * The number of consecutive health check failures required before considering the target unhealthy.
     */
    public val unhealthyThresholdCount: kotlin.Int? = builder.unhealthyThresholdCount
    /**
     * The ID of the VPC for the targets.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroup(")
        append("healthCheckEnabled=$healthCheckEnabled,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckPath=$healthCheckPath,")
        append("healthCheckPort=$healthCheckPort,")
        append("healthCheckProtocol=$healthCheckProtocol,")
        append("healthCheckTimeoutSeconds=$healthCheckTimeoutSeconds,")
        append("healthyThresholdCount=$healthyThresholdCount,")
        append("ipAddressType=$ipAddressType,")
        append("loadBalancerArns=$loadBalancerArns,")
        append("matcher=$matcher,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("protocolVersion=$protocolVersion,")
        append("targetGroupArn=$targetGroupArn,")
        append("targetGroupName=$targetGroupName,")
        append("targetType=$targetType,")
        append("unhealthyThresholdCount=$unhealthyThresholdCount,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthCheckEnabled?.hashCode() ?: 0
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPort?.hashCode() ?: 0)
        result = 31 * result + (healthCheckProtocol?.hashCode() ?: 0)
        result = 31 * result + (healthCheckTimeoutSeconds ?: 0)
        result = 31 * result + (healthyThresholdCount ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (matcher?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (protocolVersion?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (targetGroupName?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThresholdCount ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetGroup

        if (healthCheckEnabled != other.healthCheckEnabled) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (healthCheckPort != other.healthCheckPort) return false
        if (healthCheckProtocol != other.healthCheckProtocol) return false
        if (healthCheckTimeoutSeconds != other.healthCheckTimeoutSeconds) return false
        if (healthyThresholdCount != other.healthyThresholdCount) return false
        if (ipAddressType != other.ipAddressType) return false
        if (loadBalancerArns != other.loadBalancerArns) return false
        if (matcher != other.matcher) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (protocolVersion != other.protocolVersion) return false
        if (targetGroupArn != other.targetGroupArn) return false
        if (targetGroupName != other.targetGroupName) return false
        if (targetType != other.targetType) return false
        if (unhealthyThresholdCount != other.unhealthyThresholdCount) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether health checks are enabled.
         */
        public var healthCheckEnabled: kotlin.Boolean? = null
        /**
         * The approximate amount of time, in seconds, between health checks of an individual target.
         */
        public var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * The destination for health checks on the targets.
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * The port to use to connect with the target.
         */
        public var healthCheckPort: kotlin.String? = null
        /**
         * The protocol to use to connect with the target. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         */
        public var healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * The amount of time, in seconds, during which no response means a failed health check.
         */
        public var healthCheckTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         */
        public var healthyThresholdCount: kotlin.Int? = null
        /**
         * The type of IP address used for this target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum? = null
        /**
         * The Amazon Resource Name (ARN) of the load balancer that routes traffic to this target group. You can use each target group with only one load balancer.
         */
        public var loadBalancerArns: List<String>? = null
        /**
         * The HTTP or gRPC codes to use when checking for a successful response from a target.
         */
        public var matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = null
        /**
         * The port on which the targets are listening. This parameter is not used if the target is a Lambda function.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol to use for routing traffic to the targets.
         */
        public var protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTP/HTTPS protocol&#93; The protocol version. The possible values are `GRPC`, `HTTP1`, and `HTTP2`.
         */
        public var protocolVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the target group.
         */
        public var targetGroupArn: kotlin.String? = null
        /**
         * The name of the target group.
         */
        public var targetGroupName: kotlin.String? = null
        /**
         * The type of target that you must specify when registering targets with this target group. The possible values are `instance` (register targets by instance ID), `ip` (register targets by IP address), `lambda` (register a single Lambda function as a target), or `alb` (register a single Application Load Balancer as a target).
         */
        public var targetType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetTypeEnum? = null
        /**
         * The number of consecutive health check failures required before considering the target unhealthy.
         */
        public var unhealthyThresholdCount: kotlin.Int? = null
        /**
         * The ID of the VPC for the targets.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup) : this() {
            this.healthCheckEnabled = x.healthCheckEnabled
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckPath = x.healthCheckPath
            this.healthCheckPort = x.healthCheckPort
            this.healthCheckProtocol = x.healthCheckProtocol
            this.healthCheckTimeoutSeconds = x.healthCheckTimeoutSeconds
            this.healthyThresholdCount = x.healthyThresholdCount
            this.ipAddressType = x.ipAddressType
            this.loadBalancerArns = x.loadBalancerArns
            this.matcher = x.matcher
            this.port = x.port
            this.protocol = x.protocol
            this.protocolVersion = x.protocolVersion
            this.targetGroupArn = x.targetGroupArn
            this.targetGroupName = x.targetGroupName
            this.targetType = x.targetType
            this.unhealthyThresholdCount = x.unhealthyThresholdCount
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup = TargetGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher] inside the given [block]
         */
        public fun matcher(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.Builder.() -> kotlin.Unit) {
            this.matcher = aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
