// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyTargetGroupRequest private constructor(builder: Builder) {
    /**
     * Indicates whether health checks are enabled.
     */
    public val healthCheckEnabled: kotlin.Boolean? = builder.healthCheckEnabled
    /**
     * The approximate amount of time, in seconds, between health checks of an individual target.
     */
    public val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * &#91;HTTP/HTTPS health checks&#93; The destination for health checks on the targets.
     *
     * &#91;HTTP1 or HTTP2 protocol version&#93; The ping path. The default is /.
     *
     * &#91;GRPC protocol version&#93; The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The port the load balancer uses when performing health checks on targets.
     */
    public val healthCheckPort: kotlin.String? = builder.healthCheckPort
    /**
     * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    public val healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.healthCheckProtocol
    /**
     * &#91;HTTP/HTTPS health checks&#93; The amount of time, in seconds, during which no response means a failed health check.
     */
    public val healthCheckTimeoutSeconds: kotlin.Int? = builder.healthCheckTimeoutSeconds
    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     */
    public val healthyThresholdCount: kotlin.Int? = builder.healthyThresholdCount
    /**
     * &#91;HTTP/HTTPS health checks&#93; The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.
     */
    public val matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = builder.matcher
    /**
     * The Amazon Resource Name (ARN) of the target group.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn
    /**
     * The number of consecutive health check failures required before considering the target unhealthy.
     */
    public val unhealthyThresholdCount: kotlin.Int? = builder.unhealthyThresholdCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyTargetGroupRequest(")
        append("healthCheckEnabled=$healthCheckEnabled,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckPath=$healthCheckPath,")
        append("healthCheckPort=$healthCheckPort,")
        append("healthCheckProtocol=$healthCheckProtocol,")
        append("healthCheckTimeoutSeconds=$healthCheckTimeoutSeconds,")
        append("healthyThresholdCount=$healthyThresholdCount,")
        append("matcher=$matcher,")
        append("targetGroupArn=$targetGroupArn,")
        append("unhealthyThresholdCount=$unhealthyThresholdCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthCheckEnabled?.hashCode() ?: 0
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPort?.hashCode() ?: 0)
        result = 31 * result + (healthCheckProtocol?.hashCode() ?: 0)
        result = 31 * result + (healthCheckTimeoutSeconds ?: 0)
        result = 31 * result + (healthyThresholdCount ?: 0)
        result = 31 * result + (matcher?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThresholdCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyTargetGroupRequest

        if (healthCheckEnabled != other.healthCheckEnabled) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (healthCheckPort != other.healthCheckPort) return false
        if (healthCheckProtocol != other.healthCheckProtocol) return false
        if (healthCheckTimeoutSeconds != other.healthCheckTimeoutSeconds) return false
        if (healthyThresholdCount != other.healthyThresholdCount) return false
        if (matcher != other.matcher) return false
        if (targetGroupArn != other.targetGroupArn) return false
        if (unhealthyThresholdCount != other.unhealthyThresholdCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether health checks are enabled.
         */
        public var healthCheckEnabled: kotlin.Boolean? = null
        /**
         * The approximate amount of time, in seconds, between health checks of an individual target.
         */
        public var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * &#91;HTTP/HTTPS health checks&#93; The destination for health checks on the targets.
         *
         * &#91;HTTP1 or HTTP2 protocol version&#93; The ping path. The default is /.
         *
         * &#91;GRPC protocol version&#93; The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * The port the load balancer uses when performing health checks on targets.
         */
        public var healthCheckPort: kotlin.String? = null
        /**
         * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         */
        public var healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTP/HTTPS health checks&#93; The amount of time, in seconds, during which no response means a failed health check.
         */
        public var healthCheckTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         */
        public var healthyThresholdCount: kotlin.Int? = null
        /**
         * &#91;HTTP/HTTPS health checks&#93; The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.
         */
        public var matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = null
        /**
         * The Amazon Resource Name (ARN) of the target group.
         */
        public var targetGroupArn: kotlin.String? = null
        /**
         * The number of consecutive health check failures required before considering the target unhealthy.
         */
        public var unhealthyThresholdCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest) : this() {
            this.healthCheckEnabled = x.healthCheckEnabled
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckPath = x.healthCheckPath
            this.healthCheckPort = x.healthCheckPort
            this.healthCheckProtocol = x.healthCheckProtocol
            this.healthCheckTimeoutSeconds = x.healthCheckTimeoutSeconds
            this.healthyThresholdCount = x.healthyThresholdCount
            this.matcher = x.matcher
            this.targetGroupArn = x.targetGroupArn
            this.unhealthyThresholdCount = x.unhealthyThresholdCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest = ModifyTargetGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher] inside the given [block]
         */
        public fun matcher(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.Builder.() -> kotlin.Unit) {
            this.matcher = aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
