// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a listener.
 */
public class Listener private constructor(builder: Builder) {
    /**
     * &#91;TLS listener&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     */
    public val alpnPolicy: List<String>? = builder.alpnPolicy
    /**
     * &#91;HTTPS or TLS listener&#93; The default certificate for the listener.
     */
    public val certificates: List<Certificate>? = builder.certificates
    /**
     * The default actions for the listener.
     */
    public val defaultActions: List<Action>? = builder.defaultActions
    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    public val listenerArn: kotlin.String? = builder.listenerArn
    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    public val loadBalancerArn: kotlin.String? = builder.loadBalancerArn
    /**
     * The mutual authentication configuration information.
     */
    public val mutualAuthentication: aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes? = builder.mutualAuthentication
    /**
     * The port on which the load balancer is listening.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol for connections from clients to the load balancer.
     */
    public val protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.protocol
    /**
     * &#91;HTTPS or TLS listener&#93; The security policy that defines which protocols and ciphers are supported.
     */
    public val sslPolicy: kotlin.String? = builder.sslPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Listener(")
        append("alpnPolicy=$alpnPolicy,")
        append("certificates=$certificates,")
        append("defaultActions=$defaultActions,")
        append("listenerArn=$listenerArn,")
        append("loadBalancerArn=$loadBalancerArn,")
        append("mutualAuthentication=$mutualAuthentication,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("sslPolicy=$sslPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alpnPolicy?.hashCode() ?: 0
        result = 31 * result + (certificates?.hashCode() ?: 0)
        result = 31 * result + (defaultActions?.hashCode() ?: 0)
        result = 31 * result + (listenerArn?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArn?.hashCode() ?: 0)
        result = 31 * result + (mutualAuthentication?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (sslPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Listener

        if (alpnPolicy != other.alpnPolicy) return false
        if (certificates != other.certificates) return false
        if (defaultActions != other.defaultActions) return false
        if (listenerArn != other.listenerArn) return false
        if (loadBalancerArn != other.loadBalancerArn) return false
        if (mutualAuthentication != other.mutualAuthentication) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (sslPolicy != other.sslPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;TLS listener&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         */
        public var alpnPolicy: List<String>? = null
        /**
         * &#91;HTTPS or TLS listener&#93; The default certificate for the listener.
         */
        public var certificates: List<Certificate>? = null
        /**
         * The default actions for the listener.
         */
        public var defaultActions: List<Action>? = null
        /**
         * The Amazon Resource Name (ARN) of the listener.
         */
        public var listenerArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        public var loadBalancerArn: kotlin.String? = null
        /**
         * The mutual authentication configuration information.
         */
        public var mutualAuthentication: aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes? = null
        /**
         * The port on which the load balancer is listening.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol for connections from clients to the load balancer.
         */
        public var protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTPS or TLS listener&#93; The security policy that defines which protocols and ciphers are supported.
         */
        public var sslPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener) : this() {
            this.alpnPolicy = x.alpnPolicy
            this.certificates = x.certificates
            this.defaultActions = x.defaultActions
            this.listenerArn = x.listenerArn
            this.loadBalancerArn = x.loadBalancerArn
            this.mutualAuthentication = x.mutualAuthentication
            this.port = x.port
            this.protocol = x.protocol
            this.sslPolicy = x.sslPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener = Listener(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes] inside the given [block]
         */
        public fun mutualAuthentication(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes.Builder.() -> kotlin.Unit) {
            this.mutualAuthentication = aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
