// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request parameters when using an identity provider (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
 */
public class AuthenticateOidcActionConfig private constructor(builder: Builder) {
    /**
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     */
    public val authenticationRequestExtraParams: Map<String, String>? = builder.authenticationRequestExtraParams
    /**
     * The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    public val authorizationEndpoint: kotlin.String? = builder.authorizationEndpoint
    /**
     * The OAuth 2.0 client identifier.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set `UseExistingClientSecret` to true.
     */
    public val clientSecret: kotlin.String? = builder.clientSecret
    /**
     * The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    public val issuer: kotlin.String? = builder.issuer
    /**
     * The behavior if the user is not authenticated. The following are possible values:
     * + deny`` - Return an HTTP 401 Unauthorized error.
     * + allow`` - Allow the request to be forwarded to the target.
     * + authenticate`` - Redirect the request to the IdP authorization endpoint. This is the default value.
     */
    public val onUnauthenticatedRequest: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum? = builder.onUnauthenticatedRequest
    /**
     * The set of user claims to be requested from the IdP. The default is `openid`.
     *
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     */
    public val scope: kotlin.String? = builder.scope
    /**
     * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     */
    public val sessionCookieName: kotlin.String? = builder.sessionCookieName
    /**
     * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     */
    public val sessionTimeout: kotlin.Long? = builder.sessionTimeout
    /**
     * The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    public val tokenEndpoint: kotlin.String? = builder.tokenEndpoint
    /**
     * Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
     */
    public val useExistingClientSecret: kotlin.Boolean? = builder.useExistingClientSecret
    /**
     * The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    public val userInfoEndpoint: kotlin.String? = builder.userInfoEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticateOidcActionConfig(")
        append("authenticationRequestExtraParams=$authenticationRequestExtraParams,")
        append("authorizationEndpoint=$authorizationEndpoint,")
        append("clientId=$clientId,")
        append("clientSecret=$clientSecret,")
        append("issuer=$issuer,")
        append("onUnauthenticatedRequest=$onUnauthenticatedRequest,")
        append("scope=$scope,")
        append("sessionCookieName=$sessionCookieName,")
        append("sessionTimeout=$sessionTimeout,")
        append("tokenEndpoint=$tokenEndpoint,")
        append("useExistingClientSecret=$useExistingClientSecret,")
        append("userInfoEndpoint=$userInfoEndpoint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationRequestExtraParams?.hashCode() ?: 0
        result = 31 * result + (authorizationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientSecret?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (onUnauthenticatedRequest?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (sessionCookieName?.hashCode() ?: 0)
        result = 31 * result + (sessionTimeout?.hashCode() ?: 0)
        result = 31 * result + (tokenEndpoint?.hashCode() ?: 0)
        result = 31 * result + (useExistingClientSecret?.hashCode() ?: 0)
        result = 31 * result + (userInfoEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticateOidcActionConfig

        if (authenticationRequestExtraParams != other.authenticationRequestExtraParams) return false
        if (authorizationEndpoint != other.authorizationEndpoint) return false
        if (clientId != other.clientId) return false
        if (clientSecret != other.clientSecret) return false
        if (issuer != other.issuer) return false
        if (onUnauthenticatedRequest != other.onUnauthenticatedRequest) return false
        if (scope != other.scope) return false
        if (sessionCookieName != other.sessionCookieName) return false
        if (sessionTimeout != other.sessionTimeout) return false
        if (tokenEndpoint != other.tokenEndpoint) return false
        if (useExistingClientSecret != other.useExistingClientSecret) return false
        if (userInfoEndpoint != other.userInfoEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         */
        public var authenticationRequestExtraParams: Map<String, String>? = null
        /**
         * The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
         */
        public var authorizationEndpoint: kotlin.String? = null
        /**
         * The OAuth 2.0 client identifier.
         */
        public var clientId: kotlin.String? = null
        /**
         * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set `UseExistingClientSecret` to true.
         */
        public var clientSecret: kotlin.String? = null
        /**
         * The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
         */
        public var issuer: kotlin.String? = null
        /**
         * The behavior if the user is not authenticated. The following are possible values:
         * + deny`` - Return an HTTP 401 Unauthorized error.
         * + allow`` - Allow the request to be forwarded to the target.
         * + authenticate`` - Redirect the request to the IdP authorization endpoint. This is the default value.
         */
        public var onUnauthenticatedRequest: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum? = null
        /**
         * The set of user claims to be requested from the IdP. The default is `openid`.
         *
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         */
        public var scope: kotlin.String? = null
        /**
         * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         */
        public var sessionCookieName: kotlin.String? = null
        /**
         * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
         */
        public var sessionTimeout: kotlin.Long? = null
        /**
         * The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
         */
        public var tokenEndpoint: kotlin.String? = null
        /**
         * Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
         */
        public var useExistingClientSecret: kotlin.Boolean? = null
        /**
         * The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
         */
        public var userInfoEndpoint: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig) : this() {
            this.authenticationRequestExtraParams = x.authenticationRequestExtraParams
            this.authorizationEndpoint = x.authorizationEndpoint
            this.clientId = x.clientId
            this.clientSecret = x.clientSecret
            this.issuer = x.issuer
            this.onUnauthenticatedRequest = x.onUnauthenticatedRequest
            this.scope = x.scope
            this.sessionCookieName = x.sessionCookieName
            this.sessionTimeout = x.sessionTimeout
            this.tokenEndpoint = x.tokenEndpoint
            this.useExistingClientSecret = x.useExistingClientSecret
            this.userInfoEndpoint = x.userInfoEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig = AuthenticateOidcActionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
