// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.elasticloadbalancingv2.auth.DefaultElasticLoadBalancingV2AuthSchemeProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.auth.ElasticLoadBalancingV2AuthSchemeProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.DefaultElasticLoadBalancingV2EndpointProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.ElasticLoadBalancingV2EndpointParameters
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.ElasticLoadBalancingV2EndpointProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTrustStoreRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTrustStoreResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTrustStoreRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTrustStoreResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeregisterTargetsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTrustStoreRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTrustStoreResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RegisterTargetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RegisterTargetsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Elastic Load Balancing v2"
public const val SdkVersion: String = "1.3.60"
public const val ServiceApiVersion: String = "2015-12-01"

/**
 * # Elastic Load Balancing
 * A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered targets and ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer. You configure a target group with a protocol and port number for connections from the load balancer to the targets, and with health check settings to be used when checking the health status of the targets.
 *
 * Elastic Load Balancing supports the following types of load balancers: Application Load Balancers, Network Load Balancers, Gateway Load Balancers, and Classic Load Balancers. This reference covers the following load balancer types:
 * + Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
 * + Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
 * + Gateway Load Balancer - Operates at the network layer (layer 3).
 *
 * For more information, see the [Elastic Load Balancing User Guide](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/).
 *
 * All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat an operation, it succeeds.
 */
public interface ElasticLoadBalancingV2Client : SdkClient {
    /**
     * ElasticLoadBalancingV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ElasticLoadBalancingV2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ElasticLoadBalancingV2",
                "ELASTIC_LOAD_BALANCING_V2",
                "elastic_load_balancing_v2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ElasticLoadBalancingV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ElasticLoadBalancingV2Client = DefaultElasticLoadBalancingV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ElasticLoadBalancingV2EndpointProvider = builder.endpointProvider ?: DefaultElasticLoadBalancingV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ElasticLoadBalancingV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultElasticLoadBalancingV2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Elastic Load Balancing v2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ElasticLoadBalancingV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ElasticLoadBalancingV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     *
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added again.
     *
     * For more information, see [HTTPS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html) in the *Application Load Balancers Guide* or [TLS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html) in the *Network Load Balancers Guide*.
     */
    public suspend fun addListenerCertificates(input: AddListenerCertificatesRequest): AddListenerCertificatesResponse

    /**
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     *
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, `AddTags` updates its value.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.AddTags.sample
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Adds the specified revocation file to the specified trust store.
     */
    public suspend fun addTrustStoreRevocations(input: AddTrustStoreRevocationsRequest): AddTrustStoreRevocationsResponse

    /**
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Listeners for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
     * + [Listeners for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html)
     * + [Listeners for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample2
     */
    public suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse

    /**
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
     * + [Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
     * + [Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample2
     */
    public suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse

    /**
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     *
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see [Listener rules](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules) in the *Application Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateRule.sample
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * Creates a target group.
     *
     * For more information, see the following:
     * + [Target groups for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
     * + [Target groups for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html)
     * + [Target groups for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateTargetGroup.sample
     */
    public suspend fun createTargetGroup(input: CreateTargetGroupRequest): CreateTargetGroupResponse

    /**
     * Creates a trust store.
     */
    public suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse

    /**
     * Deletes the specified listener.
     *
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteListener.sample
     */
    public suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse

    /**
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
     *
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.
     *
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteLoadBalancer.sample
     */
    public suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse

    /**
     * Deletes the specified rule.
     *
     * You can't delete the default rule.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteRule.sample
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Deletes a shared trust store association.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteSharedTrustStoreAssociation.sample
     */
    public suspend fun deleteSharedTrustStoreAssociation(input: DeleteSharedTrustStoreAssociationRequest): DeleteSharedTrustStoreAssociationResponse

    /**
     * Deletes the specified target group.
     *
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteTargetGroup.sample
     */
    public suspend fun deleteTargetGroup(input: DeleteTargetGroupRequest): DeleteTargetGroupResponse

    /**
     * Deletes a trust store.
     */
    public suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse

    /**
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
     *
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by default but can be updated for each target group.
     *
     * For more information, see the following:
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay) in the *Application Load Balancers User Guide*
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) in the *Network Load Balancers User Guide*
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay) in the *Gateway Load Balancers User Guide*
     *
     * Note: If the specified target does not exist, the action returns successfully.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeregisterTargets.sample
     */
    public suspend fun deregisterTargets(input: DeregisterTargetsRequest): DeregisterTargetsResponse

    /**
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     *
     * For more information, see the following:
     * + [Quotas for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
     * + [Quotas for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
     * + [Quotas for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html)
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest { }): DescribeAccountLimitsResponse

    /**
     * Describes the attributes for the specified listener.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListenerAttributes.sample
     */
    public suspend fun describeListenerAttributes(input: DescribeListenerAttributesRequest): DescribeListenerAttributesResponse

    /**
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     *
     * If the default certificate is also in the certificate list, it appears twice in the results (once with `IsDefault` set to true and once with `IsDefault` set to false).
     *
     * For more information, see [SSL certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates) in the *Application Load Balancers Guide* or [Server certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate) in the *Network Load Balancers Guide*.
     */
    public suspend fun describeListenerCertificates(input: DescribeListenerCertificatesRequest): DescribeListenerCertificatesResponse

    /**
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListeners.sample
     */
    public suspend fun describeListeners(input: DescribeListenersRequest = DescribeListenersRequest { }): DescribeListenersResponse

    /**
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes) in the *Application Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes) in the *Network Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes) in the *Gateway Load Balancers Guide*
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancerAttributes.sample
     */
    public suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse

    /**
     * Describes the specified load balancers or all of your load balancers.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancers.sample
     */
    public suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest = DescribeLoadBalancersRequest { }): DescribeLoadBalancersResponse

    /**
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeRules.sample
     */
    public suspend fun describeRules(input: DescribeRulesRequest = DescribeRulesRequest { }): DescribeRulesResponse

    /**
     * Describes the specified policies or all policies used for SSL negotiation.
     *
     * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeSSLPolicies.sample
     */
    public suspend fun describeSslPolicies(input: DescribeSslPoliciesRequest = DescribeSslPoliciesRequest { }): DescribeSslPoliciesResponse

    /**
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTags.sample
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the attributes for the specified target group.
     *
     * For more information, see the following:
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes) in the *Application Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes) in the *Network Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes) in the *Gateway Load Balancers Guide*
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroupAttributes.sample
     */
    public suspend fun describeTargetGroupAttributes(input: DescribeTargetGroupAttributesRequest): DescribeTargetGroupAttributesResponse

    /**
     * Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroups.sample
     */
    public suspend fun describeTargetGroups(input: DescribeTargetGroupsRequest = DescribeTargetGroupsRequest { }): DescribeTargetGroupsResponse

    /**
     * Describes the health of the specified targets or all of your targets.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample2
     */
    public suspend fun describeTargetHealth(input: DescribeTargetHealthRequest): DescribeTargetHealthResponse

    /**
     * Describes all resources associated with the specified trust store.
     */
    public suspend fun describeTrustStoreAssociations(input: DescribeTrustStoreAssociationsRequest): DescribeTrustStoreAssociationsResponse

    /**
     * Describes the revocation files in use by the specified trust store or revocation files.
     */
    public suspend fun describeTrustStoreRevocations(input: DescribeTrustStoreRevocationsRequest): DescribeTrustStoreRevocationsResponse

    /**
     * Describes all trust stores for the specified account.
     */
    public suspend fun describeTrustStores(input: DescribeTrustStoresRequest = DescribeTrustStoresRequest { }): DescribeTrustStoresResponse

    /**
     * Retrieves the resource policy for a specified resource.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.GetResourcePolicy.sample
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Retrieves the ca certificate bundle.
     *
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     */
    public suspend fun getTrustStoreCaCertificatesBundle(input: GetTrustStoreCaCertificatesBundleRequest): GetTrustStoreCaCertificatesBundleResponse

    /**
     * Retrieves the specified revocation file.
     *
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     */
    public suspend fun getTrustStoreRevocationContent(input: GetTrustStoreRevocationContentRequest): GetTrustStoreRevocationContentResponse

    /**
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
     *
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample2
     */
    public suspend fun modifyListener(input: ModifyListenerRequest): ModifyListenerResponse

    /**
     * Modifies the specified attributes of the specified listener.
     */
    public suspend fun modifyListenerAttributes(input: ModifyListenerAttributesRequest): ModifyListenerAttributesResponse

    /**
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample2
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample3
     */
    public suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse

    /**
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyRule.sample
     */
    public suspend fun modifyRule(input: ModifyRuleRequest): ModifyRuleResponse

    /**
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroup.sample
     */
    public suspend fun modifyTargetGroup(input: ModifyTargetGroupRequest): ModifyTargetGroupResponse

    /**
     * Modifies the specified attributes of the specified target group.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroupAttributes.sample
     */
    public suspend fun modifyTargetGroupAttributes(input: ModifyTargetGroupAttributesRequest): ModifyTargetGroupAttributesResponse

    /**
     * Update the ca certificate bundle for the specified trust store.
     */
    public suspend fun modifyTrustStore(input: ModifyTrustStoreRequest): ModifyTrustStoreResponse

    /**
     * Registers the specified targets with the specified target group.
     *
     * If the target is an EC2 instance, it must be in the `running` state when you register it.
     *
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.
     *
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample2
     */
    public suspend fun registerTargets(input: RegisterTargetsRequest): RegisterTargetsResponse

    /**
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     */
    public suspend fun removeListenerCertificates(input: RemoveListenerCertificatesRequest): RemoveListenerCertificatesResponse

    /**
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RemoveTags.sample
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes the specified revocation file from the specified trust store.
     */
    public suspend fun removeTrustStoreRevocations(input: RemoveTrustStoreRevocationsRequest): RemoveTrustStoreRevocationsResponse

    /**
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     */
    public suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse

    /**
     * Sets the priorities of the specified rules.
     *
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetRulePriorities.sample
     */
    public suspend fun setRulePriorities(input: SetRulePrioritiesRequest): SetRulePrioritiesResponse

    /**
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer. The specified security groups override the previously associated security groups.
     *
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load balancer when you created it.
     *
     * You can't associate a security group with a Gateway Load Balancer.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSecurityGroups.sample
     */
    public suspend fun setSecurityGroups(input: SetSecurityGroupsRequest): SetSecurityGroupsResponse

    /**
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     *
     * When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSubnets.sample
     */
    public suspend fun setSubnets(input: SetSubnetsRequest): SetSubnetsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ElasticLoadBalancingV2Client.withConfig(block: ElasticLoadBalancingV2Client.Config.Builder.() -> Unit): ElasticLoadBalancingV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultElasticLoadBalancingV2Client(newConfig)
}

/**
 * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
 *
 * If the certificate in already in the certificate list, the call is successful but the certificate is not added again.
 *
 * For more information, see [HTTPS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html) in the *Application Load Balancers Guide* or [TLS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html) in the *Network Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.addListenerCertificates(crossinline block: AddListenerCertificatesRequest.Builder.() -> Unit): AddListenerCertificatesResponse = addListenerCertificates(AddListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
 *
 * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, `AddTags` updates its value.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.AddTags.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Adds the specified revocation file to the specified trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.addTrustStoreRevocations(crossinline block: AddTrustStoreRevocationsRequest.Builder.() -> Unit): AddTrustStoreRevocationsResponse = addTrustStoreRevocations(AddTrustStoreRevocationsRequest.Builder().apply(block).build())

/**
 * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Listeners for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
 * + [Listeners for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html)
 * + [Listeners for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample2
 */
public suspend inline fun ElasticLoadBalancingV2Client.createListener(crossinline block: CreateListenerRequest.Builder.() -> Unit): CreateListenerResponse = createListener(CreateListenerRequest.Builder().apply(block).build())

/**
 * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
 * + [Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
 * + [Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample2
 */
public suspend inline fun ElasticLoadBalancingV2Client.createLoadBalancer(crossinline block: CreateLoadBalancerRequest.Builder.() -> Unit): CreateLoadBalancerResponse = createLoadBalancer(CreateLoadBalancerRequest.Builder().apply(block).build())

/**
 * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
 *
 * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see [Listener rules](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules) in the *Application Load Balancers Guide*.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateRule.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * Creates a target group.
 *
 * For more information, see the following:
 * + [Target groups for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
 * + [Target groups for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html)
 * + [Target groups for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateTargetGroup.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.createTargetGroup(crossinline block: CreateTargetGroupRequest.Builder.() -> Unit): CreateTargetGroupResponse = createTargetGroup(CreateTargetGroupRequest.Builder().apply(block).build())

/**
 * Creates a trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.createTrustStore(crossinline block: CreateTrustStoreRequest.Builder.() -> Unit): CreateTrustStoreResponse = createTrustStore(CreateTrustStoreRequest.Builder().apply(block).build())

/**
 * Deletes the specified listener.
 *
 * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteListener.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteListener(crossinline block: DeleteListenerRequest.Builder.() -> Unit): DeleteListenerResponse = deleteListener(DeleteListenerRequest.Builder().apply(block).build())

/**
 * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
 *
 * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.
 *
 * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteLoadBalancer.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteLoadBalancer(crossinline block: DeleteLoadBalancerRequest.Builder.() -> Unit): DeleteLoadBalancerResponse = deleteLoadBalancer(DeleteLoadBalancerRequest.Builder().apply(block).build())

/**
 * Deletes the specified rule.
 *
 * You can't delete the default rule.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteRule.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Deletes a shared trust store association.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteSharedTrustStoreAssociation.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteSharedTrustStoreAssociation(crossinline block: DeleteSharedTrustStoreAssociationRequest.Builder.() -> Unit): DeleteSharedTrustStoreAssociationResponse = deleteSharedTrustStoreAssociation(DeleteSharedTrustStoreAssociationRequest.Builder().apply(block).build())

/**
 * Deletes the specified target group.
 *
 * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteTargetGroup.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteTargetGroup(crossinline block: DeleteTargetGroupRequest.Builder.() -> Unit): DeleteTargetGroupResponse = deleteTargetGroup(DeleteTargetGroupRequest.Builder().apply(block).build())

/**
 * Deletes a trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteTrustStore(crossinline block: DeleteTrustStoreRequest.Builder.() -> Unit): DeleteTrustStoreResponse = deleteTrustStore(DeleteTrustStoreRequest.Builder().apply(block).build())

/**
 * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
 *
 * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by default but can be updated for each target group.
 *
 * For more information, see the following:
 * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay) in the *Application Load Balancers User Guide*
 * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) in the *Network Load Balancers User Guide*
 * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay) in the *Gateway Load Balancers User Guide*
 *
 * Note: If the specified target does not exist, the action returns successfully.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeregisterTargets.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.deregisterTargets(crossinline block: DeregisterTargetsRequest.Builder.() -> Unit): DeregisterTargetsResponse = deregisterTargets(DeregisterTargetsRequest.Builder().apply(block).build())

/**
 * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
 *
 * For more information, see the following:
 * + [Quotas for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
 * + [Quotas for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
 * + [Quotas for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html)
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified listener.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListenerAttributes.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeListenerAttributes(crossinline block: DescribeListenerAttributesRequest.Builder.() -> Unit): DescribeListenerAttributesResponse = describeListenerAttributes(DescribeListenerAttributesRequest.Builder().apply(block).build())

/**
 * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
 *
 * If the default certificate is also in the certificate list, it appears twice in the results (once with `IsDefault` set to true and once with `IsDefault` set to false).
 *
 * For more information, see [SSL certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates) in the *Application Load Balancers Guide* or [Server certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate) in the *Network Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeListenerCertificates(crossinline block: DescribeListenerCertificatesRequest.Builder.() -> Unit): DescribeListenerCertificatesResponse = describeListenerCertificates(DescribeListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListeners.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeListeners(crossinline block: DescribeListenersRequest.Builder.() -> Unit): DescribeListenersResponse = describeListeners(DescribeListenersRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes) in the *Application Load Balancers Guide*
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes) in the *Network Load Balancers Guide*
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes) in the *Gateway Load Balancers Guide*
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancerAttributes.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeLoadBalancerAttributes(crossinline block: DescribeLoadBalancerAttributesRequest.Builder.() -> Unit): DescribeLoadBalancerAttributesResponse = describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Describes the specified load balancers or all of your load balancers.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancers.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeLoadBalancers(crossinline block: DescribeLoadBalancersRequest.Builder.() -> Unit): DescribeLoadBalancersResponse = describeLoadBalancers(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeRules.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeRules(crossinline block: DescribeRulesRequest.Builder.() -> Unit): DescribeRulesResponse = describeRules(DescribeRulesRequest.Builder().apply(block).build())

/**
 * Describes the specified policies or all policies used for SSL negotiation.
 *
 * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeSSLPolicies.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeSslPolicies(crossinline block: DescribeSslPoliciesRequest.Builder.() -> Unit): DescribeSslPoliciesResponse = describeSslPolicies(DescribeSslPoliciesRequest.Builder().apply(block).build())

/**
 * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTags.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified target group.
 *
 * For more information, see the following:
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes) in the *Application Load Balancers Guide*
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes) in the *Network Load Balancers Guide*
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes) in the *Gateway Load Balancers Guide*
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroupAttributes.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetGroupAttributes(crossinline block: DescribeTargetGroupAttributesRequest.Builder.() -> Unit): DescribeTargetGroupAttributesResponse = describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest.Builder().apply(block).build())

/**
 * Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroups.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetGroups(crossinline block: DescribeTargetGroupsRequest.Builder.() -> Unit): DescribeTargetGroupsResponse = describeTargetGroups(DescribeTargetGroupsRequest.Builder().apply(block).build())

/**
 * Describes the health of the specified targets or all of your targets.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample2
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetHealth(crossinline block: DescribeTargetHealthRequest.Builder.() -> Unit): DescribeTargetHealthResponse = describeTargetHealth(DescribeTargetHealthRequest.Builder().apply(block).build())

/**
 * Describes all resources associated with the specified trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTrustStoreAssociations(crossinline block: DescribeTrustStoreAssociationsRequest.Builder.() -> Unit): DescribeTrustStoreAssociationsResponse = describeTrustStoreAssociations(DescribeTrustStoreAssociationsRequest.Builder().apply(block).build())

/**
 * Describes the revocation files in use by the specified trust store or revocation files.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTrustStoreRevocations(crossinline block: DescribeTrustStoreRevocationsRequest.Builder.() -> Unit): DescribeTrustStoreRevocationsResponse = describeTrustStoreRevocations(DescribeTrustStoreRevocationsRequest.Builder().apply(block).build())

/**
 * Describes all trust stores for the specified account.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTrustStores(crossinline block: DescribeTrustStoresRequest.Builder.() -> Unit): DescribeTrustStoresResponse = describeTrustStores(DescribeTrustStoresRequest.Builder().apply(block).build())

/**
 * Retrieves the resource policy for a specified resource.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.GetResourcePolicy.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the ca certificate bundle.
 *
 * This action returns a pre-signed S3 URI which is active for ten minutes.
 */
public suspend inline fun ElasticLoadBalancingV2Client.getTrustStoreCaCertificatesBundle(crossinline block: GetTrustStoreCaCertificatesBundleRequest.Builder.() -> Unit): GetTrustStoreCaCertificatesBundleResponse = getTrustStoreCaCertificatesBundle(GetTrustStoreCaCertificatesBundleRequest.Builder().apply(block).build())

/**
 * Retrieves the specified revocation file.
 *
 * This action returns a pre-signed S3 URI which is active for ten minutes.
 */
public suspend inline fun ElasticLoadBalancingV2Client.getTrustStoreRevocationContent(crossinline block: GetTrustStoreRevocationContentRequest.Builder.() -> Unit): GetTrustStoreRevocationContentResponse = getTrustStoreRevocationContent(GetTrustStoreRevocationContentRequest.Builder().apply(block).build())

/**
 * Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
 *
 * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.
 *
 * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample2
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyListener(crossinline block: ModifyListenerRequest.Builder.() -> Unit): ModifyListenerResponse = modifyListener(ModifyListenerRequest.Builder().apply(block).build())

/**
 * Modifies the specified attributes of the specified listener.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyListenerAttributes(crossinline block: ModifyListenerAttributesRequest.Builder.() -> Unit): ModifyListenerAttributesResponse = modifyListenerAttributes(ModifyListenerAttributesRequest.Builder().apply(block).build())

/**
 * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample2
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample3
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyLoadBalancerAttributes(crossinline block: ModifyLoadBalancerAttributesRequest.Builder.() -> Unit): ModifyLoadBalancerAttributesResponse = modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
 *
 * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyRule.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyRule(crossinline block: ModifyRuleRequest.Builder.() -> Unit): ModifyRuleResponse = modifyRule(ModifyRuleRequest.Builder().apply(block).build())

/**
 * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroup.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyTargetGroup(crossinline block: ModifyTargetGroupRequest.Builder.() -> Unit): ModifyTargetGroupResponse = modifyTargetGroup(ModifyTargetGroupRequest.Builder().apply(block).build())

/**
 * Modifies the specified attributes of the specified target group.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroupAttributes.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyTargetGroupAttributes(crossinline block: ModifyTargetGroupAttributesRequest.Builder.() -> Unit): ModifyTargetGroupAttributesResponse = modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest.Builder().apply(block).build())

/**
 * Update the ca certificate bundle for the specified trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyTrustStore(crossinline block: ModifyTrustStoreRequest.Builder.() -> Unit): ModifyTrustStoreResponse = modifyTrustStore(ModifyTrustStoreRequest.Builder().apply(block).build())

/**
 * Registers the specified targets with the specified target group.
 *
 * If the target is an EC2 instance, it must be in the `running` state when you register it.
 *
 * By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.
 *
 * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample2
 */
public suspend inline fun ElasticLoadBalancingV2Client.registerTargets(crossinline block: RegisterTargetsRequest.Builder.() -> Unit): RegisterTargetsResponse = registerTargets(RegisterTargetsRequest.Builder().apply(block).build())

/**
 * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
 */
public suspend inline fun ElasticLoadBalancingV2Client.removeListenerCertificates(crossinline block: RemoveListenerCertificatesRequest.Builder.() -> Unit): RemoveListenerCertificatesResponse = removeListenerCertificates(RemoveListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RemoveTags.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Removes the specified revocation file from the specified trust store.
 */
public suspend inline fun ElasticLoadBalancingV2Client.removeTrustStoreRevocations(crossinline block: RemoveTrustStoreRevocationsRequest.Builder.() -> Unit): RemoveTrustStoreRevocationsResponse = removeTrustStoreRevocations(RemoveTrustStoreRevocationsRequest.Builder().apply(block).build())

/**
 * Sets the type of IP addresses used by the subnets of the specified load balancer.
 */
public suspend inline fun ElasticLoadBalancingV2Client.setIpAddressType(crossinline block: SetIpAddressTypeRequest.Builder.() -> Unit): SetIpAddressTypeResponse = setIpAddressType(SetIpAddressTypeRequest.Builder().apply(block).build())

/**
 * Sets the priorities of the specified rules.
 *
 * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetRulePriorities.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.setRulePriorities(crossinline block: SetRulePrioritiesRequest.Builder.() -> Unit): SetRulePrioritiesResponse = setRulePriorities(SetRulePrioritiesRequest.Builder().apply(block).build())

/**
 * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer. The specified security groups override the previously associated security groups.
 *
 * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load balancer when you created it.
 *
 * You can't associate a security group with a Gateway Load Balancer.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSecurityGroups.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.setSecurityGroups(crossinline block: SetSecurityGroupsRequest.Builder.() -> Unit): SetSecurityGroupsResponse = setSecurityGroups(SetSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
 *
 * When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.
 *
 * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSubnets.sample
 */
public suspend inline fun ElasticLoadBalancingV2Client.setSubnets(crossinline block: SetSubnetsRequest.Builder.() -> Unit): SetSubnetsResponse = setSubnets(SetSubnetsRequest.Builder().apply(block).build())
