// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.elasticloadbalancingv2.auth.ElasticLoadBalancingV2AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.elasticloadbalancingv2.auth.ElasticLoadBalancingV2IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.*
import aws.sdk.kotlin.services.elasticloadbalancingv2.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultElasticLoadBalancingV2Client(override val config: ElasticLoadBalancingV2Client.Config) : ElasticLoadBalancingV2Client {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ElasticLoadBalancingV2IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "elasticloadbalancing")
        }
        toMap()
    }
    private val authSchemeAdapter = ElasticLoadBalancingV2AuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.elasticloadbalancingv2"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     *
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added again.
     *
     * For more information, see [HTTPS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html) in the *Application Load Balancers Guide* or [TLS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html) in the *Network Load Balancers Guide*.
     */
    override suspend fun addListenerCertificates(input: AddListenerCertificatesRequest): AddListenerCertificatesResponse {
        val op = SdkHttpOperation.build<AddListenerCertificatesRequest, AddListenerCertificatesResponse> {
            serializeWith = AddListenerCertificatesOperationSerializer()
            deserializeWith = AddListenerCertificatesOperationDeserializer()
            operationName = "AddListenerCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     *
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, `AddTags` updates its value.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.AddTags.sample
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializeWith = AddTagsOperationSerializer()
            deserializeWith = AddTagsOperationDeserializer()
            operationName = "AddTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified revocation file to the specified trust store.
     */
    override suspend fun addTrustStoreRevocations(input: AddTrustStoreRevocationsRequest): AddTrustStoreRevocationsResponse {
        val op = SdkHttpOperation.build<AddTrustStoreRevocationsRequest, AddTrustStoreRevocationsResponse> {
            serializeWith = AddTrustStoreRevocationsOperationSerializer()
            deserializeWith = AddTrustStoreRevocationsOperationDeserializer()
            operationName = "AddTrustStoreRevocations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Listeners for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
     * + [Listeners for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html)
     * + [Listeners for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateListener.sample2
     */
    override suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse {
        val op = SdkHttpOperation.build<CreateListenerRequest, CreateListenerResponse> {
            serializeWith = CreateListenerOperationSerializer()
            deserializeWith = CreateListenerOperationDeserializer()
            operationName = "CreateListener"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
     * + [Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
     * + [Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateLoadBalancer.sample2
     */
    override suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerRequest, CreateLoadBalancerResponse> {
            serializeWith = CreateLoadBalancerOperationSerializer()
            deserializeWith = CreateLoadBalancerOperationDeserializer()
            operationName = "CreateLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     *
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see [Listener rules](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules) in the *Application Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateRule.sample
     */
    override suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse {
        val op = SdkHttpOperation.build<CreateRuleRequest, CreateRuleResponse> {
            serializeWith = CreateRuleOperationSerializer()
            deserializeWith = CreateRuleOperationDeserializer()
            operationName = "CreateRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a target group.
     *
     * For more information, see the following:
     * + [Target groups for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
     * + [Target groups for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html)
     * + [Target groups for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.CreateTargetGroup.sample
     */
    override suspend fun createTargetGroup(input: CreateTargetGroupRequest): CreateTargetGroupResponse {
        val op = SdkHttpOperation.build<CreateTargetGroupRequest, CreateTargetGroupResponse> {
            serializeWith = CreateTargetGroupOperationSerializer()
            deserializeWith = CreateTargetGroupOperationDeserializer()
            operationName = "CreateTargetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a trust store.
     */
    override suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse {
        val op = SdkHttpOperation.build<CreateTrustStoreRequest, CreateTrustStoreResponse> {
            serializeWith = CreateTrustStoreOperationSerializer()
            deserializeWith = CreateTrustStoreOperationDeserializer()
            operationName = "CreateTrustStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified listener.
     *
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteListener.sample
     */
    override suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse {
        val op = SdkHttpOperation.build<DeleteListenerRequest, DeleteListenerResponse> {
            serializeWith = DeleteListenerOperationSerializer()
            deserializeWith = DeleteListenerOperationDeserializer()
            operationName = "DeleteListener"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
     *
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.
     *
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteLoadBalancer.sample
     */
    override suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> {
            serializeWith = DeleteLoadBalancerOperationSerializer()
            deserializeWith = DeleteLoadBalancerOperationDeserializer()
            operationName = "DeleteLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified rule.
     *
     * You can't delete the default rule.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteRule.sample
     */
    override suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse {
        val op = SdkHttpOperation.build<DeleteRuleRequest, DeleteRuleResponse> {
            serializeWith = DeleteRuleOperationSerializer()
            deserializeWith = DeleteRuleOperationDeserializer()
            operationName = "DeleteRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a shared trust store association.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteSharedTrustStoreAssociation.sample
     */
    override suspend fun deleteSharedTrustStoreAssociation(input: DeleteSharedTrustStoreAssociationRequest): DeleteSharedTrustStoreAssociationResponse {
        val op = SdkHttpOperation.build<DeleteSharedTrustStoreAssociationRequest, DeleteSharedTrustStoreAssociationResponse> {
            serializeWith = DeleteSharedTrustStoreAssociationOperationSerializer()
            deserializeWith = DeleteSharedTrustStoreAssociationOperationDeserializer()
            operationName = "DeleteSharedTrustStoreAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified target group.
     *
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeleteTargetGroup.sample
     */
    override suspend fun deleteTargetGroup(input: DeleteTargetGroupRequest): DeleteTargetGroupResponse {
        val op = SdkHttpOperation.build<DeleteTargetGroupRequest, DeleteTargetGroupResponse> {
            serializeWith = DeleteTargetGroupOperationSerializer()
            deserializeWith = DeleteTargetGroupOperationDeserializer()
            operationName = "DeleteTargetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a trust store.
     */
    override suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse {
        val op = SdkHttpOperation.build<DeleteTrustStoreRequest, DeleteTrustStoreResponse> {
            serializeWith = DeleteTrustStoreOperationSerializer()
            deserializeWith = DeleteTrustStoreOperationDeserializer()
            operationName = "DeleteTrustStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
     *
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by default but can be updated for each target group.
     *
     * For more information, see the following:
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay) in the *Application Load Balancers User Guide*
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) in the *Network Load Balancers User Guide*
     * + [ Deregistration delay](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay) in the *Gateway Load Balancers User Guide*
     *
     * Note: If the specified target does not exist, the action returns successfully.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DeregisterTargets.sample
     */
    override suspend fun deregisterTargets(input: DeregisterTargetsRequest): DeregisterTargetsResponse {
        val op = SdkHttpOperation.build<DeregisterTargetsRequest, DeregisterTargetsResponse> {
            serializeWith = DeregisterTargetsOperationSerializer()
            deserializeWith = DeregisterTargetsOperationDeserializer()
            operationName = "DeregisterTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     *
     * For more information, see the following:
     * + [Quotas for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
     * + [Quotas for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
     * + [Quotas for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html)
     */
    override suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse {
        val op = SdkHttpOperation.build<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse> {
            serializeWith = DescribeAccountLimitsOperationSerializer()
            deserializeWith = DescribeAccountLimitsOperationDeserializer()
            operationName = "DescribeAccountLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes for the specified listener.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListenerAttributes.sample
     */
    override suspend fun describeListenerAttributes(input: DescribeListenerAttributesRequest): DescribeListenerAttributesResponse {
        val op = SdkHttpOperation.build<DescribeListenerAttributesRequest, DescribeListenerAttributesResponse> {
            serializeWith = DescribeListenerAttributesOperationSerializer()
            deserializeWith = DescribeListenerAttributesOperationDeserializer()
            operationName = "DescribeListenerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     *
     * If the default certificate is also in the certificate list, it appears twice in the results (once with `IsDefault` set to true and once with `IsDefault` set to false).
     *
     * For more information, see [SSL certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates) in the *Application Load Balancers Guide* or [Server certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate) in the *Network Load Balancers Guide*.
     */
    override suspend fun describeListenerCertificates(input: DescribeListenerCertificatesRequest): DescribeListenerCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeListenerCertificatesRequest, DescribeListenerCertificatesResponse> {
            serializeWith = DescribeListenerCertificatesOperationSerializer()
            deserializeWith = DescribeListenerCertificatesOperationDeserializer()
            operationName = "DescribeListenerCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeListeners.sample
     */
    override suspend fun describeListeners(input: DescribeListenersRequest): DescribeListenersResponse {
        val op = SdkHttpOperation.build<DescribeListenersRequest, DescribeListenersResponse> {
            serializeWith = DescribeListenersOperationSerializer()
            deserializeWith = DescribeListenersOperationDeserializer()
            operationName = "DescribeListeners"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes) in the *Application Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes) in the *Network Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes) in the *Gateway Load Balancers Guide*
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancerAttributes.sample
     */
    override suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse> {
            serializeWith = DescribeLoadBalancerAttributesOperationSerializer()
            deserializeWith = DescribeLoadBalancerAttributesOperationDeserializer()
            operationName = "DescribeLoadBalancerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified load balancers or all of your load balancers.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeLoadBalancers.sample
     */
    override suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest): DescribeLoadBalancersResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse> {
            serializeWith = DescribeLoadBalancersOperationSerializer()
            deserializeWith = DescribeLoadBalancersOperationDeserializer()
            operationName = "DescribeLoadBalancers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeRules.sample
     */
    override suspend fun describeRules(input: DescribeRulesRequest): DescribeRulesResponse {
        val op = SdkHttpOperation.build<DescribeRulesRequest, DescribeRulesResponse> {
            serializeWith = DescribeRulesOperationSerializer()
            deserializeWith = DescribeRulesOperationDeserializer()
            operationName = "DescribeRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified policies or all policies used for SSL negotiation.
     *
     * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeSSLPolicies.sample
     */
    override suspend fun describeSslPolicies(input: DescribeSslPoliciesRequest): DescribeSslPoliciesResponse {
        val op = SdkHttpOperation.build<DescribeSslPoliciesRequest, DescribeSslPoliciesResponse> {
            serializeWith = DescribeSSLPoliciesOperationSerializer()
            deserializeWith = DescribeSSLPoliciesOperationDeserializer()
            operationName = "DescribeSSLPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTags.sample
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializeWith = DescribeTagsOperationSerializer()
            deserializeWith = DescribeTagsOperationDeserializer()
            operationName = "DescribeTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes for the specified target group.
     *
     * For more information, see the following:
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes) in the *Application Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes) in the *Network Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes) in the *Gateway Load Balancers Guide*
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroupAttributes.sample
     */
    override suspend fun describeTargetGroupAttributes(input: DescribeTargetGroupAttributesRequest): DescribeTargetGroupAttributesResponse {
        val op = SdkHttpOperation.build<DescribeTargetGroupAttributesRequest, DescribeTargetGroupAttributesResponse> {
            serializeWith = DescribeTargetGroupAttributesOperationSerializer()
            deserializeWith = DescribeTargetGroupAttributesOperationDeserializer()
            operationName = "DescribeTargetGroupAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetGroups.sample
     */
    override suspend fun describeTargetGroups(input: DescribeTargetGroupsRequest): DescribeTargetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeTargetGroupsRequest, DescribeTargetGroupsResponse> {
            serializeWith = DescribeTargetGroupsOperationSerializer()
            deserializeWith = DescribeTargetGroupsOperationDeserializer()
            operationName = "DescribeTargetGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the health of the specified targets or all of your targets.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.DescribeTargetHealth.sample2
     */
    override suspend fun describeTargetHealth(input: DescribeTargetHealthRequest): DescribeTargetHealthResponse {
        val op = SdkHttpOperation.build<DescribeTargetHealthRequest, DescribeTargetHealthResponse> {
            serializeWith = DescribeTargetHealthOperationSerializer()
            deserializeWith = DescribeTargetHealthOperationDeserializer()
            operationName = "DescribeTargetHealth"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes all resources associated with the specified trust store.
     */
    override suspend fun describeTrustStoreAssociations(input: DescribeTrustStoreAssociationsRequest): DescribeTrustStoreAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeTrustStoreAssociationsRequest, DescribeTrustStoreAssociationsResponse> {
            serializeWith = DescribeTrustStoreAssociationsOperationSerializer()
            deserializeWith = DescribeTrustStoreAssociationsOperationDeserializer()
            operationName = "DescribeTrustStoreAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the revocation files in use by the specified trust store or revocation files.
     */
    override suspend fun describeTrustStoreRevocations(input: DescribeTrustStoreRevocationsRequest): DescribeTrustStoreRevocationsResponse {
        val op = SdkHttpOperation.build<DescribeTrustStoreRevocationsRequest, DescribeTrustStoreRevocationsResponse> {
            serializeWith = DescribeTrustStoreRevocationsOperationSerializer()
            deserializeWith = DescribeTrustStoreRevocationsOperationDeserializer()
            operationName = "DescribeTrustStoreRevocations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes all trust stores for the specified account.
     */
    override suspend fun describeTrustStores(input: DescribeTrustStoresRequest): DescribeTrustStoresResponse {
        val op = SdkHttpOperation.build<DescribeTrustStoresRequest, DescribeTrustStoresResponse> {
            serializeWith = DescribeTrustStoresOperationSerializer()
            deserializeWith = DescribeTrustStoresOperationDeserializer()
            operationName = "DescribeTrustStores"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the resource policy for a specified resource.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.GetResourcePolicy.sample
     */
    override suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse {
        val op = SdkHttpOperation.build<GetResourcePolicyRequest, GetResourcePolicyResponse> {
            serializeWith = GetResourcePolicyOperationSerializer()
            deserializeWith = GetResourcePolicyOperationDeserializer()
            operationName = "GetResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the ca certificate bundle.
     *
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     */
    override suspend fun getTrustStoreCaCertificatesBundle(input: GetTrustStoreCaCertificatesBundleRequest): GetTrustStoreCaCertificatesBundleResponse {
        val op = SdkHttpOperation.build<GetTrustStoreCaCertificatesBundleRequest, GetTrustStoreCaCertificatesBundleResponse> {
            serializeWith = GetTrustStoreCaCertificatesBundleOperationSerializer()
            deserializeWith = GetTrustStoreCaCertificatesBundleOperationDeserializer()
            operationName = "GetTrustStoreCaCertificatesBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the specified revocation file.
     *
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     */
    override suspend fun getTrustStoreRevocationContent(input: GetTrustStoreRevocationContentRequest): GetTrustStoreRevocationContentResponse {
        val op = SdkHttpOperation.build<GetTrustStoreRevocationContentRequest, GetTrustStoreRevocationContentResponse> {
            serializeWith = GetTrustStoreRevocationContentOperationSerializer()
            deserializeWith = GetTrustStoreRevocationContentOperationDeserializer()
            operationName = "GetTrustStoreRevocationContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
     *
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyListener.sample2
     */
    override suspend fun modifyListener(input: ModifyListenerRequest): ModifyListenerResponse {
        val op = SdkHttpOperation.build<ModifyListenerRequest, ModifyListenerResponse> {
            serializeWith = ModifyListenerOperationSerializer()
            deserializeWith = ModifyListenerOperationDeserializer()
            operationName = "ModifyListener"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attributes of the specified listener.
     */
    override suspend fun modifyListenerAttributes(input: ModifyListenerAttributesRequest): ModifyListenerAttributesResponse {
        val op = SdkHttpOperation.build<ModifyListenerAttributesRequest, ModifyListenerAttributesResponse> {
            serializeWith = ModifyListenerAttributesOperationSerializer()
            deserializeWith = ModifyListenerAttributesOperationDeserializer()
            operationName = "ModifyListenerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample2
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyLoadBalancerAttributes.sample3
     */
    override suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse> {
            serializeWith = ModifyLoadBalancerAttributesOperationSerializer()
            deserializeWith = ModifyLoadBalancerAttributesOperationDeserializer()
            operationName = "ModifyLoadBalancerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyRule.sample
     */
    override suspend fun modifyRule(input: ModifyRuleRequest): ModifyRuleResponse {
        val op = SdkHttpOperation.build<ModifyRuleRequest, ModifyRuleResponse> {
            serializeWith = ModifyRuleOperationSerializer()
            deserializeWith = ModifyRuleOperationDeserializer()
            operationName = "ModifyRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroup.sample
     */
    override suspend fun modifyTargetGroup(input: ModifyTargetGroupRequest): ModifyTargetGroupResponse {
        val op = SdkHttpOperation.build<ModifyTargetGroupRequest, ModifyTargetGroupResponse> {
            serializeWith = ModifyTargetGroupOperationSerializer()
            deserializeWith = ModifyTargetGroupOperationDeserializer()
            operationName = "ModifyTargetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attributes of the specified target group.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.ModifyTargetGroupAttributes.sample
     */
    override suspend fun modifyTargetGroupAttributes(input: ModifyTargetGroupAttributesRequest): ModifyTargetGroupAttributesResponse {
        val op = SdkHttpOperation.build<ModifyTargetGroupAttributesRequest, ModifyTargetGroupAttributesResponse> {
            serializeWith = ModifyTargetGroupAttributesOperationSerializer()
            deserializeWith = ModifyTargetGroupAttributesOperationDeserializer()
            operationName = "ModifyTargetGroupAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the ca certificate bundle for the specified trust store.
     */
    override suspend fun modifyTrustStore(input: ModifyTrustStoreRequest): ModifyTrustStoreResponse {
        val op = SdkHttpOperation.build<ModifyTrustStoreRequest, ModifyTrustStoreResponse> {
            serializeWith = ModifyTrustStoreOperationSerializer()
            deserializeWith = ModifyTrustStoreOperationDeserializer()
            operationName = "ModifyTrustStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers the specified targets with the specified target group.
     *
     * If the target is an EC2 instance, it must be in the `running` state when you register it.
     *
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.
     *
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RegisterTargets.sample2
     */
    override suspend fun registerTargets(input: RegisterTargetsRequest): RegisterTargetsResponse {
        val op = SdkHttpOperation.build<RegisterTargetsRequest, RegisterTargetsResponse> {
            serializeWith = RegisterTargetsOperationSerializer()
            deserializeWith = RegisterTargetsOperationDeserializer()
            operationName = "RegisterTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     */
    override suspend fun removeListenerCertificates(input: RemoveListenerCertificatesRequest): RemoveListenerCertificatesResponse {
        val op = SdkHttpOperation.build<RemoveListenerCertificatesRequest, RemoveListenerCertificatesResponse> {
            serializeWith = RemoveListenerCertificatesOperationSerializer()
            deserializeWith = RemoveListenerCertificatesOperationDeserializer()
            operationName = "RemoveListenerCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.RemoveTags.sample
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializeWith = RemoveTagsOperationSerializer()
            deserializeWith = RemoveTagsOperationDeserializer()
            operationName = "RemoveTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified revocation file from the specified trust store.
     */
    override suspend fun removeTrustStoreRevocations(input: RemoveTrustStoreRevocationsRequest): RemoveTrustStoreRevocationsResponse {
        val op = SdkHttpOperation.build<RemoveTrustStoreRevocationsRequest, RemoveTrustStoreRevocationsResponse> {
            serializeWith = RemoveTrustStoreRevocationsOperationSerializer()
            deserializeWith = RemoveTrustStoreRevocationsOperationDeserializer()
            operationName = "RemoveTrustStoreRevocations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     */
    override suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse {
        val op = SdkHttpOperation.build<SetIpAddressTypeRequest, SetIpAddressTypeResponse> {
            serializeWith = SetIpAddressTypeOperationSerializer()
            deserializeWith = SetIpAddressTypeOperationDeserializer()
            operationName = "SetIpAddressType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the priorities of the specified rules.
     *
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetRulePriorities.sample
     */
    override suspend fun setRulePriorities(input: SetRulePrioritiesRequest): SetRulePrioritiesResponse {
        val op = SdkHttpOperation.build<SetRulePrioritiesRequest, SetRulePrioritiesResponse> {
            serializeWith = SetRulePrioritiesOperationSerializer()
            deserializeWith = SetRulePrioritiesOperationDeserializer()
            operationName = "SetRulePriorities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer. The specified security groups override the previously associated security groups.
     *
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load balancer when you created it.
     *
     * You can't associate a security group with a Gateway Load Balancer.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSecurityGroups.sample
     */
    override suspend fun setSecurityGroups(input: SetSecurityGroupsRequest): SetSecurityGroupsResponse {
        val op = SdkHttpOperation.build<SetSecurityGroupsRequest, SetSecurityGroupsResponse> {
            serializeWith = SetSecurityGroupsOperationSerializer()
            deserializeWith = SetSecurityGroupsOperationDeserializer()
            operationName = "SetSecurityGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     *
     * When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancingv2.samples.SetSubnets.sample
     */
    override suspend fun setSubnets(input: SetSubnetsRequest): SetSubnetsResponse {
        val op = SdkHttpOperation.build<SetSubnetsRequest, SetSubnetsResponse> {
            serializeWith = SetSubnetsOperationSerializer()
            deserializeWith = SetSubnetsOperationDeserializer()
            operationName = "SetSubnets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elasticloadbalancing")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
