// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Action
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Certificate
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyListenerOperationSerializer: HttpSerialize<ModifyListenerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ModifyListenerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeModifyListenerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeModifyListenerOperationBody(context: ExecutionContext, input: ModifyListenerRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ALPNPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("AlpnPolicy"))
    val CERTIFICATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Certificates"))
    val DEFAULTACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("DefaultActions"))
    val LISTENERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ListenerArn"))
    val MUTUALAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("MutualAuthentication"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("Protocol"))
    val SSLPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SslPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ModifyListenerInput"))
        trait(QueryLiteral("Action", "ModifyListener"))
        trait(QueryLiteral("Version", "2015-12-01"))
        field(ALPNPOLICY_DESCRIPTOR)
        field(CERTIFICATES_DESCRIPTOR)
        field(DEFAULTACTIONS_DESCRIPTOR)
        field(LISTENERARN_DESCRIPTOR)
        field(MUTUALAUTHENTICATION_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(SSLPOLICY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.alpnPolicy != null) {
            listField(ALPNPOLICY_DESCRIPTOR) {
                for (el0 in input.alpnPolicy) {
                    serializeString(el0)
                }
            }
        }
        if (input.certificates != null) {
            listField(CERTIFICATES_DESCRIPTOR) {
                for (el0 in input.certificates) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCertificateDocument))
                }
            }
        }
        if (input.defaultActions != null) {
            listField(DEFAULTACTIONS_DESCRIPTOR) {
                for (el0 in input.defaultActions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeActionDocument))
                }
            }
        }
        input.listenerArn?.let { field(LISTENERARN_DESCRIPTOR, it) }
        input.mutualAuthentication?.let { field(MUTUALAUTHENTICATION_DESCRIPTOR, it, ::serializeMutualAuthenticationAttributesDocument) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.protocol?.let { field(PROTOCOL_DESCRIPTOR, it.value) }
        input.sslPolicy?.let { field(SSLPOLICY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
