// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ModifyListenerOperationDeserializer: HttpDeserialize<ModifyListenerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyListenerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyListenerError(context, call)
        }
        val builder = ModifyListenerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyListenerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyListenerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ALPNPolicyNotFound" -> AlpnPolicyNotSupportedExceptionDeserializer().deserialize(context, wrappedCall)
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRegistrationsForTargetId" -> TooManyRegistrationsForTargetIdExceptionDeserializer().deserialize(context, wrappedCall)
        "TrustStoreNotReady" -> TrustStoreNotReadyExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLoadBalancerAction" -> InvalidLoadBalancerActionExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyTargets" -> TooManyTargetsExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyActions" -> TooManyActionsExceptionDeserializer().deserialize(context, wrappedCall)
        "DuplicateListener" -> DuplicateListenerExceptionDeserializer().deserialize(context, wrappedCall)
        "SSLPolicyNotFound" -> SslPolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TargetGroupAssociationLimit" -> TargetGroupAssociationLimitExceptionDeserializer().deserialize(context, wrappedCall)
        "IncompatibleProtocols" -> IncompatibleProtocolsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedCall)
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyUniqueTargetGroupsPerLoadBalancer" -> TooManyUniqueTargetGroupsPerLoadBalancerExceptionDeserializer().deserialize(context, wrappedCall)
        "TargetGroupNotFound" -> TargetGroupNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyCertificates" -> TooManyCertificatesExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyListeners" -> TooManyListenersExceptionDeserializer().deserialize(context, wrappedCall)
        "TrustStoreNotFound" -> TrustStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyListenerOperationBody(builder: ModifyListenerResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyListenerResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyListenerResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyListener response")
    }
    // end unwrap response wrapper

    val LISTENERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Listeners"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2015-12-01/"))
        trait(XmlSerialName("ModifyListenerResult"))
        field(LISTENERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LISTENERS_DESCRIPTOR.index -> builder.listeners =
                    deserializer.deserializeList(LISTENERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Listener>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListenerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
