// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.serde

import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteTargetGroupOperationDeserializer: HttpDeserialize<DeleteTargetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteTargetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteTargetGroupError(context, call)
        }
        val builder = DeleteTargetGroupResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteTargetGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceInUse" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
