// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.paginators

import aws.sdk.kotlin.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroup
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenersPaginated(initialRequest: DescribeListenersRequest = DescribeListenersRequest { }): Flow<DescribeListenersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeListenersPaginated.describeListeners(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeListenersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeListenersPaginated(block: DescribeListenersRequest.Builder.() -> Unit): Flow<DescribeListenersResponse> =
    describeListenersPaginated(DescribeListenersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeListenersPaginated]
 * to access the nested member [Listener]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Listener]
 */
@JvmName("describeListenersResponseListener")
public fun Flow<DescribeListenersResponse>.listeners(): Flow<Listener> =
    transform() { response ->
        response.listeners?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLoadBalancersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeLoadBalancersPaginated(initialRequest: DescribeLoadBalancersRequest = DescribeLoadBalancersRequest { }): Flow<DescribeLoadBalancersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeLoadBalancersPaginated.describeLoadBalancers(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingV2Client.describeLoadBalancersPaginated(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Flow<DescribeLoadBalancersResponse> =
    describeLoadBalancersPaginated(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLoadBalancersPaginated]
 * to access the nested member [LoadBalancer]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LoadBalancer]
 */
@JvmName("describeLoadBalancersResponseLoadBalancer")
public fun Flow<DescribeLoadBalancersResponse>.loadBalancers(): Flow<LoadBalancer> =
    transform() { response ->
        response.loadBalancers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTargetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTargetGroupsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTargetGroupsPaginated(initialRequest: DescribeTargetGroupsRequest = DescribeTargetGroupsRequest { }): Flow<DescribeTargetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTargetGroupsPaginated.describeTargetGroups(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTargetGroupsResponse]
 */
public fun ElasticLoadBalancingV2Client.describeTargetGroupsPaginated(block: DescribeTargetGroupsRequest.Builder.() -> Unit): Flow<DescribeTargetGroupsResponse> =
    describeTargetGroupsPaginated(DescribeTargetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTargetGroupsPaginated]
 * to access the nested member [TargetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TargetGroup]
 */
@JvmName("describeTargetGroupsResponseTargetGroup")
public fun Flow<DescribeTargetGroupsResponse>.targetGroups(): Flow<TargetGroup> =
    transform() { response ->
        response.targetGroups?.forEach {
            emit(it)
        }
    }
