// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about the current health of a target.
 */
public class TargetHealth private constructor(builder: Builder) {
    /**
     * A description of the target health that provides additional details. If the state is `healthy`, a description is not provided.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The reason code.
     *
     * If the target state is `healthy`, a reason code is not provided.
     *
     * If the target state is `initial`, the reason code can be one of the following values:
     * + `Elb.RegistrationInProgress` - The target is in the process of being registered with the load balancer.
     * + `Elb.InitialHealthChecking` - The load balancer is still sending the target the minimum number of health checks required to determine its health status.
     *
     * If the target state is `unhealthy`, the reason code can be one of the following values:
     * + `Target.ResponseCodeMismatch` - The health checks did not return an expected HTTP code. Applies only to Application Load Balancers and Gateway Load Balancers.
     * + `Target.Timeout` - The health check requests timed out. Applies only to Application Load Balancers and Gateway Load Balancers.
     * + `Target.FailedHealthChecks` - The load balancer received an error while establishing a connection to the target or the target response was malformed.
     * + `Elb.InternalError` - The health checks failed due to an internal error. Applies only to Application Load Balancers.
     *
     * If the target state is `unused`, the reason code can be one of the following values:
     * + `Target.NotRegistered` - The target is not registered with the target group.
     * + `Target.NotInUse` - The target group is not used by any load balancer or the target is in an Availability Zone that is not enabled for its load balancer.
     * + `Target.InvalidState` - The target is in the stopped or terminated state.
     * + `Target.IpUnusable` - The target IP address is reserved for use by a load balancer.
     *
     * If the target state is `draining`, the reason code can be the following value:
     * + `Target.DeregistrationInProgress` - The target is in the process of being deregistered and the deregistration delay period has not expired.
     *
     * If the target state is `unavailable`, the reason code can be the following value:
     * + `Target.HealthCheckDisabled` - Health checks are disabled for the target group. Applies only to Application Load Balancers.
     * + `Elb.InternalError` - Target health is unavailable due to an internal error. Applies only to Network Load Balancers.
     */
    public val reason: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealthReasonEnum? = builder.reason
    /**
     * The state of the target.
     */
    public val state: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealthStateEnum? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealth = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetHealth(")
        append("description=$description,")
        append("reason=$reason,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetHealth

        if (description != other.description) return false
        if (reason != other.reason) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealth = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the target health that provides additional details. If the state is `healthy`, a description is not provided.
         */
        public var description: kotlin.String? = null
        /**
         * The reason code.
         *
         * If the target state is `healthy`, a reason code is not provided.
         *
         * If the target state is `initial`, the reason code can be one of the following values:
         * + `Elb.RegistrationInProgress` - The target is in the process of being registered with the load balancer.
         * + `Elb.InitialHealthChecking` - The load balancer is still sending the target the minimum number of health checks required to determine its health status.
         *
         * If the target state is `unhealthy`, the reason code can be one of the following values:
         * + `Target.ResponseCodeMismatch` - The health checks did not return an expected HTTP code. Applies only to Application Load Balancers and Gateway Load Balancers.
         * + `Target.Timeout` - The health check requests timed out. Applies only to Application Load Balancers and Gateway Load Balancers.
         * + `Target.FailedHealthChecks` - The load balancer received an error while establishing a connection to the target or the target response was malformed.
         * + `Elb.InternalError` - The health checks failed due to an internal error. Applies only to Application Load Balancers.
         *
         * If the target state is `unused`, the reason code can be one of the following values:
         * + `Target.NotRegistered` - The target is not registered with the target group.
         * + `Target.NotInUse` - The target group is not used by any load balancer or the target is in an Availability Zone that is not enabled for its load balancer.
         * + `Target.InvalidState` - The target is in the stopped or terminated state.
         * + `Target.IpUnusable` - The target IP address is reserved for use by a load balancer.
         *
         * If the target state is `draining`, the reason code can be the following value:
         * + `Target.DeregistrationInProgress` - The target is in the process of being deregistered and the deregistration delay period has not expired.
         *
         * If the target state is `unavailable`, the reason code can be the following value:
         * + `Target.HealthCheckDisabled` - Health checks are disabled for the target group. Applies only to Application Load Balancers.
         * + `Elb.InternalError` - Target health is unavailable due to an internal error. Applies only to Network Load Balancers.
         */
        public var reason: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealthReasonEnum? = null
        /**
         * The state of the target.
         */
        public var state: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealthStateEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealth) : this() {
            this.description = x.description
            this.reason = x.reason
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetHealth = TargetHealth(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
