// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about an HTTP header condition.
 *
 * There is a set of standard HTTP header fields. You can also define custom HTTP header fields.
 */
public class HttpHeaderConditionConfig private constructor(builder: Builder) {
    /**
     * The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
     *
     * You can't use an HTTP header condition to specify the host header. Use HostHeaderConditionConfig to specify a host header condition.
     */
    public val httpHeaderName: kotlin.String? = builder.httpHeaderName
    /**
     * The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
     *
     * If the same header appears multiple times in the request, we search them in order until a match is found.
     *
     * If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpHeaderConditionConfig(")
        append("httpHeaderName=$httpHeaderName,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpHeaderName?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpHeaderConditionConfig

        if (httpHeaderName != other.httpHeaderName) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
         *
         * You can't use an HTTP header condition to specify the host header. Use HostHeaderConditionConfig to specify a host header condition.
         */
        public var httpHeaderName: kotlin.String? = null
        /**
         * The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         *
         * If the same header appears multiple times in the request, we search them in order until a match is found.
         *
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig) : this() {
            this.httpHeaderName = x.httpHeaderName
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig = HttpHeaderConditionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
