// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints

import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultElasticLoadBalancingV2EndpointProvider: ElasticLoadBalancingV2EndpointProvider {
    public override suspend fun resolveEndpoint(params: ElasticLoadBalancingV2EndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint, UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://elasticloadbalancing-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            if (
                                partitionResult?.name == "aws-us-gov"
                            ) {
                                return Endpoint(
                                    Url.parse("https://elasticloadbalancing.${params.region}.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            return Endpoint(
                                Url.parse("https://elasticloadbalancing-fips.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://elasticloadbalancing.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://elasticloadbalancing.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
