// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class EnableAvailabilityZonesForLoadBalancerOperationDeserializer: HttpDeserializer.NonStreaming<EnableAvailabilityZonesForLoadBalancerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EnableAvailabilityZonesForLoadBalancerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEnableAvailabilityZonesForLoadBalancerError(context, call, payload)
        }
        val builder = EnableAvailabilityZonesForLoadBalancerResponse.Builder()

        if (payload != null) {
            deserializeEnableAvailabilityZonesForLoadBalancerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEnableAvailabilityZonesForLoadBalancerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEnableAvailabilityZonesForLoadBalancerOperationBody(builder: EnableAvailabilityZonesForLoadBalancerResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "EnableAvailabilityZonesForLoadBalancer")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AvailabilityZones com.amazonaws.elasticloadbalancing#AddAvailabilityZonesOutput$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
