// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a load balancer.
 */
public class LoadBalancerDescription private constructor(builder: Builder) {
    /**
     * The Availability Zones for the load balancer.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Information about your EC2 instances.
     */
    public val backendServerDescriptions: List<BackendServerDescription>? = builder.backendServerDescriptions
    /**
     * The DNS name of the load balancer.
     *
     * For more information, see [Configure a Custom Domain Name](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html) in the *Classic Load Balancers Guide*.
     */
    public val canonicalHostedZoneName: kotlin.String? = builder.canonicalHostedZoneName
    /**
     * The ID of the Amazon Route 53 hosted zone for the load balancer.
     */
    public val canonicalHostedZoneNameId: kotlin.String? = builder.canonicalHostedZoneNameId
    /**
     * The date and time the load balancer was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The DNS name of the load balancer.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * Information about the health checks conducted on the load balancer.
     */
    public val healthCheck: aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck? = builder.healthCheck
    /**
     * The IDs of the instances for the load balancer.
     */
    public val instances: List<Instance>? = builder.instances
    /**
     * The listeners for the load balancer.
     */
    public val listenerDescriptions: List<ListenerDescription>? = builder.listenerDescriptions
    /**
     * The name of the load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The policies defined for the load balancer.
     */
    public val policies: aws.sdk.kotlin.services.elasticloadbalancing.model.Policies? = builder.policies
    /**
     * The type of load balancer. Valid only for load balancers in a VPC.
     *
     * If `Scheme` is `internet-facing`, the load balancer has a public DNS name that resolves to a public IP address.
     *
     * If `Scheme` is `internal`, the load balancer has a public DNS name that resolves to a private IP address.
     */
    public val scheme: kotlin.String? = builder.scheme
    /**
     * The security groups for the load balancer. Valid only for load balancers in a VPC.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The security group for the load balancer, which you can use as part of your inbound rules for your registered instances. To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.
     */
    public val sourceSecurityGroup: aws.sdk.kotlin.services.elasticloadbalancing.model.SourceSecurityGroup? = builder.sourceSecurityGroup
    /**
     * The IDs of the subnets for the load balancer.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The ID of the VPC for the load balancer.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerDescription(")
        append("availabilityZones=$availabilityZones,")
        append("backendServerDescriptions=$backendServerDescriptions,")
        append("canonicalHostedZoneName=$canonicalHostedZoneName,")
        append("canonicalHostedZoneNameId=$canonicalHostedZoneNameId,")
        append("createdTime=$createdTime,")
        append("dnsName=$dnsName,")
        append("healthCheck=$healthCheck,")
        append("instances=$instances,")
        append("listenerDescriptions=$listenerDescriptions,")
        append("loadBalancerName=$loadBalancerName,")
        append("policies=$policies,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("sourceSecurityGroup=$sourceSecurityGroup,")
        append("subnets=$subnets,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backendServerDescriptions?.hashCode() ?: 0)
        result = 31 * result + (canonicalHostedZoneName?.hashCode() ?: 0)
        result = 31 * result + (canonicalHostedZoneNameId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (listenerDescriptions?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerDescription

        if (availabilityZones != other.availabilityZones) return false
        if (backendServerDescriptions != other.backendServerDescriptions) return false
        if (canonicalHostedZoneName != other.canonicalHostedZoneName) return false
        if (canonicalHostedZoneNameId != other.canonicalHostedZoneNameId) return false
        if (createdTime != other.createdTime) return false
        if (dnsName != other.dnsName) return false
        if (healthCheck != other.healthCheck) return false
        if (instances != other.instances) return false
        if (listenerDescriptions != other.listenerDescriptions) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (policies != other.policies) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (sourceSecurityGroup != other.sourceSecurityGroup) return false
        if (subnets != other.subnets) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zones for the load balancer.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Information about your EC2 instances.
         */
        public var backendServerDescriptions: List<BackendServerDescription>? = null
        /**
         * The DNS name of the load balancer.
         *
         * For more information, see [Configure a Custom Domain Name](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html) in the *Classic Load Balancers Guide*.
         */
        public var canonicalHostedZoneName: kotlin.String? = null
        /**
         * The ID of the Amazon Route 53 hosted zone for the load balancer.
         */
        public var canonicalHostedZoneNameId: kotlin.String? = null
        /**
         * The date and time the load balancer was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS name of the load balancer.
         */
        public var dnsName: kotlin.String? = null
        /**
         * Information about the health checks conducted on the load balancer.
         */
        public var healthCheck: aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck? = null
        /**
         * The IDs of the instances for the load balancer.
         */
        public var instances: List<Instance>? = null
        /**
         * The listeners for the load balancer.
         */
        public var listenerDescriptions: List<ListenerDescription>? = null
        /**
         * The name of the load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The policies defined for the load balancer.
         */
        public var policies: aws.sdk.kotlin.services.elasticloadbalancing.model.Policies? = null
        /**
         * The type of load balancer. Valid only for load balancers in a VPC.
         *
         * If `Scheme` is `internet-facing`, the load balancer has a public DNS name that resolves to a public IP address.
         *
         * If `Scheme` is `internal`, the load balancer has a public DNS name that resolves to a private IP address.
         */
        public var scheme: kotlin.String? = null
        /**
         * The security groups for the load balancer. Valid only for load balancers in a VPC.
         */
        public var securityGroups: List<String>? = null
        /**
         * The security group for the load balancer, which you can use as part of your inbound rules for your registered instances. To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.
         */
        public var sourceSecurityGroup: aws.sdk.kotlin.services.elasticloadbalancing.model.SourceSecurityGroup? = null
        /**
         * The IDs of the subnets for the load balancer.
         */
        public var subnets: List<String>? = null
        /**
         * The ID of the VPC for the load balancer.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription) : this() {
            this.availabilityZones = x.availabilityZones
            this.backendServerDescriptions = x.backendServerDescriptions
            this.canonicalHostedZoneName = x.canonicalHostedZoneName
            this.canonicalHostedZoneNameId = x.canonicalHostedZoneNameId
            this.createdTime = x.createdTime
            this.dnsName = x.dnsName
            this.healthCheck = x.healthCheck
            this.instances = x.instances
            this.listenerDescriptions = x.listenerDescriptions
            this.loadBalancerName = x.loadBalancerName
            this.policies = x.policies
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.sourceSecurityGroup = x.sourceSecurityGroup
            this.subnets = x.subnets
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription = LoadBalancerDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.Policies] inside the given [block]
         */
        public fun policies(block: aws.sdk.kotlin.services.elasticloadbalancing.model.Policies.Builder.() -> kotlin.Unit) {
            this.policies = aws.sdk.kotlin.services.elasticloadbalancing.model.Policies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.SourceSecurityGroup] inside the given [block]
         */
        public fun sourceSecurityGroup(block: aws.sdk.kotlin.services.elasticloadbalancing.model.SourceSecurityGroup.Builder.() -> kotlin.Unit) {
            this.sourceSecurityGroup = aws.sdk.kotlin.services.elasticloadbalancing.model.SourceSecurityGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
