// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a listener.
 *
 * For information about the protocols and the ports supported by Elastic Load Balancing, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
 */
public class Listener private constructor(builder: Builder) {
    /**
     * The port on which the instance is listening.
     */
    public val instancePort: kotlin.Int = requireNotNull(builder.instancePort) { "A non-null value must be provided for instancePort" }
    /**
     * The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.
     *
     * If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
     *
     * If there is another listener with the same `InstancePort` whose `InstanceProtocol` is secure, (HTTPS or SSL), the listener's `InstanceProtocol` must also be secure.
     *
     * If there is another listener with the same `InstancePort` whose `InstanceProtocol` is HTTP or TCP, the listener's `InstanceProtocol` must be HTTP or TCP.
     */
    public val instanceProtocol: kotlin.String? = builder.instanceProtocol
    /**
     * The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
     */
    public val loadBalancerPort: kotlin.Int = builder.loadBalancerPort
    /**
     * The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
     */
    public val protocol: kotlin.String = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The Amazon Resource Name (ARN) of the server certificate.
     */
    public val sslCertificateId: kotlin.String? = builder.sslCertificateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.Listener = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Listener(")
        append("instancePort=$instancePort,")
        append("instanceProtocol=$instanceProtocol,")
        append("loadBalancerPort=$loadBalancerPort,")
        append("protocol=$protocol,")
        append("sslCertificateId=$sslCertificateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instancePort
        result = 31 * result + (instanceProtocol?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerPort)
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (sslCertificateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Listener

        if (instancePort != other.instancePort) return false
        if (instanceProtocol != other.instanceProtocol) return false
        if (loadBalancerPort != other.loadBalancerPort) return false
        if (protocol != other.protocol) return false
        if (sslCertificateId != other.sslCertificateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.Listener = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The port on which the instance is listening.
         */
        public var instancePort: kotlin.Int? = null
        /**
         * The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.
         *
         * If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
         *
         * If there is another listener with the same `InstancePort` whose `InstanceProtocol` is secure, (HTTPS or SSL), the listener's `InstanceProtocol` must also be secure.
         *
         * If there is another listener with the same `InstancePort` whose `InstanceProtocol` is HTTP or TCP, the listener's `InstanceProtocol` must be HTTP or TCP.
         */
        public var instanceProtocol: kotlin.String? = null
        /**
         * The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
         */
        public var loadBalancerPort: kotlin.Int = 0
        /**
         * The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
         */
        public var protocol: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the server certificate.
         */
        public var sslCertificateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.Listener) : this() {
            this.instancePort = x.instancePort
            this.instanceProtocol = x.instanceProtocol
            this.loadBalancerPort = x.loadBalancerPort
            this.protocol = x.protocol
            this.sslCertificateId = x.sslCertificateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.Listener = Listener(this)

        internal fun correctErrors(): Builder {
            if (instancePort == null) instancePort = 0
            if (protocol == null) protocol = ""
            return this
        }
    }
}
