// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.elasticloadbalancing.auth.ElasticLoadBalancingAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.elasticloadbalancing.auth.ElasticLoadBalancingIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.elasticloadbalancing.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.elasticloadbalancing.model.*
import aws.sdk.kotlin.services.elasticloadbalancing.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultElasticLoadBalancingClient(override val config: ElasticLoadBalancingClient.Config) : ElasticLoadBalancingClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ElasticLoadBalancingIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "elasticloadbalancing")
        }
        toMap()
    }
    private val authSchemeAdapter = ElasticLoadBalancingAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.elasticloadbalancing"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, `AddTags` updates its value.
     *
     * For more information, see [Tag Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.AddTags.sample
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializeWith = AddTagsOperationSerializer()
            deserializeWith = AddTagsOperationDeserializer()
            operationName = "AddTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
     *
     * For more information, see [Security Groups for Load Balancers in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.ApplySecurityGroupsToLoadBalancer.sample
     */
    override suspend fun applySecurityGroupsToLoadBalancer(input: ApplySecurityGroupsToLoadBalancerRequest): ApplySecurityGroupsToLoadBalancerResponse {
        val op = SdkHttpOperation.build<ApplySecurityGroupsToLoadBalancerRequest, ApplySecurityGroupsToLoadBalancerResponse> {
            serializeWith = ApplySecurityGroupsToLoadBalancerOperationSerializer()
            deserializeWith = ApplySecurityGroupsToLoadBalancerOperationDeserializer()
            operationName = "ApplySecurityGroupsToLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more subnets to the set of configured subnets for the specified load balancer.
     *
     * The load balancer evenly distributes requests across all registered subnets. For more information, see [Add or Remove Subnets for Your Load Balancer in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.AttachLoadBalancerToSubnets.sample
     */
    override suspend fun attachLoadBalancerToSubnets(input: AttachLoadBalancerToSubnetsRequest): AttachLoadBalancerToSubnetsResponse {
        val op = SdkHttpOperation.build<AttachLoadBalancerToSubnetsRequest, AttachLoadBalancerToSubnetsResponse> {
            serializeWith = AttachLoadBalancerToSubnetsOperationSerializer()
            deserializeWith = AttachLoadBalancerToSubnetsOperationDeserializer()
            operationName = "AttachLoadBalancerToSubnets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
     *
     * For more information, see [Configure Health Checks for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.ConfigureHealthCheck.sample
     */
    override suspend fun configureHealthCheck(input: ConfigureHealthCheckRequest): ConfigureHealthCheckResponse {
        val op = SdkHttpOperation.build<ConfigureHealthCheckRequest, ConfigureHealthCheckResponse> {
            serializeWith = ConfigureHealthCheckOperationSerializer()
            deserializeWith = ConfigureHealthCheckOperationDeserializer()
            operationName = "ConfigureHealthCheck"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
     *
     * This policy is similar to the policy created by CreateLBCookieStickinessPolicy, except that the lifetime of the special Elastic Load Balancing cookie, `AWSELB`, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.
     *
     * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
     *
     * For more information, see [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateAppCookieStickinessPolicy.sample
     */
    override suspend fun createAppCookieStickinessPolicy(input: CreateAppCookieStickinessPolicyRequest): CreateAppCookieStickinessPolicyResponse {
        val op = SdkHttpOperation.build<CreateAppCookieStickinessPolicyRequest, CreateAppCookieStickinessPolicyResponse> {
            serializeWith = CreateAppCookieStickinessPolicyOperationSerializer()
            deserializeWith = CreateAppCookieStickinessPolicyOperationDeserializer()
            operationName = "CreateAppCookieStickinessPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
     *
     * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
     *
     * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
     *
     * For more information, see [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLBCookieStickinessPolicy.sample
     */
    override suspend fun createLbCookieStickinessPolicy(input: CreateLbCookieStickinessPolicyRequest): CreateLbCookieStickinessPolicyResponse {
        val op = SdkHttpOperation.build<CreateLbCookieStickinessPolicyRequest, CreateLbCookieStickinessPolicyResponse> {
            serializeWith = CreateLBCookieStickinessPolicyOperationSerializer()
            deserializeWith = CreateLBCookieStickinessPolicyOperationDeserializer()
            operationName = "CreateLBCookieStickinessPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Classic Load Balancer.
     *
     * You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets, and AddTags.
     *
     * To describe your current load balancers, see DescribeLoadBalancers. When you are finished with a load balancer, you can delete it using DeleteLoadBalancer.
     *
     * You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancer.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancer.sample2
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancer.sample3
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancer.sample4
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancer.sample5
     */
    override suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerRequest, CreateLoadBalancerResponse> {
            serializeWith = CreateLoadBalancerOperationSerializer()
            deserializeWith = CreateLoadBalancerOperationDeserializer()
            operationName = "CreateLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
     *
     * For more information, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancerListeners.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancerListeners.sample2
     */
    override suspend fun createLoadBalancerListeners(input: CreateLoadBalancerListenersRequest): CreateLoadBalancerListenersResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerListenersRequest, CreateLoadBalancerListenersResponse> {
            serializeWith = CreateLoadBalancerListenersOperationSerializer()
            deserializeWith = CreateLoadBalancerListenersOperationDeserializer()
            operationName = "CreateLoadBalancerListeners"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a policy with the specified attributes for the specified load balancer.
     *
     * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancerPolicy.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancerPolicy.sample2
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.CreateLoadBalancerPolicy.sample3
     */
    override suspend fun createLoadBalancerPolicy(input: CreateLoadBalancerPolicyRequest): CreateLoadBalancerPolicyResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerPolicyRequest, CreateLoadBalancerPolicyResponse> {
            serializeWith = CreateLoadBalancerPolicyOperationSerializer()
            deserializeWith = CreateLoadBalancerPolicyOperationDeserializer()
            operationName = "CreateLoadBalancerPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified load balancer.
     *
     * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
     *
     * If the load balancer does not exist or has already been deleted, the call to `DeleteLoadBalancer` still succeeds.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DeleteLoadBalancer.sample
     */
    override suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> {
            serializeWith = DeleteLoadBalancerOperationSerializer()
            deserializeWith = DeleteLoadBalancerOperationDeserializer()
            operationName = "DeleteLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified listeners from the specified load balancer.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DeleteLoadBalancerListeners.sample
     */
    override suspend fun deleteLoadBalancerListeners(input: DeleteLoadBalancerListenersRequest): DeleteLoadBalancerListenersResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerListenersRequest, DeleteLoadBalancerListenersResponse> {
            serializeWith = DeleteLoadBalancerListenersOperationSerializer()
            deserializeWith = DeleteLoadBalancerListenersOperationDeserializer()
            operationName = "DeleteLoadBalancerListeners"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DeleteLoadBalancerPolicy.sample
     */
    override suspend fun deleteLoadBalancerPolicy(input: DeleteLoadBalancerPolicyRequest): DeleteLoadBalancerPolicyResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerPolicyRequest, DeleteLoadBalancerPolicyResponse> {
            serializeWith = DeleteLoadBalancerPolicyOperationSerializer()
            deserializeWith = DeleteLoadBalancerPolicyOperationDeserializer()
            operationName = "DeleteLoadBalancerPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
     *
     * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
     *
     * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DeregisterInstancesFromLoadBalancer.sample
     */
    override suspend fun deregisterInstancesFromLoadBalancer(input: DeregisterInstancesFromLoadBalancerRequest): DeregisterInstancesFromLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeregisterInstancesFromLoadBalancerRequest, DeregisterInstancesFromLoadBalancerResponse> {
            serializeWith = DeregisterInstancesFromLoadBalancerOperationSerializer()
            deserializeWith = DeregisterInstancesFromLoadBalancerOperationDeserializer()
            operationName = "DeregisterInstancesFromLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     *
     * For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
     */
    override suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse {
        val op = SdkHttpOperation.build<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse> {
            serializeWith = DescribeAccountLimitsOperationSerializer()
            deserializeWith = DescribeAccountLimitsOperationDeserializer()
            operationName = "DescribeAccountLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeInstanceHealth.sample
     */
    override suspend fun describeInstanceHealth(input: DescribeInstanceHealthRequest): DescribeInstanceHealthResponse {
        val op = SdkHttpOperation.build<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse> {
            serializeWith = DescribeInstanceHealthOperationSerializer()
            deserializeWith = DescribeInstanceHealthOperationDeserializer()
            operationName = "DescribeInstanceHealth"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes for the specified load balancer.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeLoadBalancerAttributes.sample
     */
    override suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse> {
            serializeWith = DescribeLoadBalancerAttributesOperationSerializer()
            deserializeWith = DescribeLoadBalancerAttributesOperationDeserializer()
            operationName = "DescribeLoadBalancerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified policies.
     *
     * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the `ELBSample-` prefix.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeLoadBalancerPolicies.sample
     */
    override suspend fun describeLoadBalancerPolicies(input: DescribeLoadBalancerPoliciesRequest): DescribeLoadBalancerPoliciesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerPoliciesRequest, DescribeLoadBalancerPoliciesResponse> {
            serializeWith = DescribeLoadBalancerPoliciesOperationSerializer()
            deserializeWith = DescribeLoadBalancerPoliciesOperationDeserializer()
            operationName = "DescribeLoadBalancerPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified load balancer policy types or all load balancer policy types.
     *
     * The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances.
     *
     * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types. Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or SetLoadBalancerPoliciesForBackendServer to set the policy.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeLoadBalancerPolicyTypes.sample
     */
    override suspend fun describeLoadBalancerPolicyTypes(input: DescribeLoadBalancerPolicyTypesRequest): DescribeLoadBalancerPolicyTypesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerPolicyTypesRequest, DescribeLoadBalancerPolicyTypesResponse> {
            serializeWith = DescribeLoadBalancerPolicyTypesOperationSerializer()
            deserializeWith = DescribeLoadBalancerPolicyTypesOperationDeserializer()
            operationName = "DescribeLoadBalancerPolicyTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeLoadBalancers.sample
     */
    override suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest): DescribeLoadBalancersResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse> {
            serializeWith = DescribeLoadBalancersOperationSerializer()
            deserializeWith = DescribeLoadBalancersOperationDeserializer()
            operationName = "DescribeLoadBalancers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tags associated with the specified load balancers.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DescribeTags.sample
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializeWith = DescribeTagsOperationSerializer()
            deserializeWith = DescribeTagsOperationDeserializer()
            operationName = "DescribeTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified subnets from the set of configured subnets for the load balancer.
     *
     * After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the `OutOfService` state. Then, the load balancer balances the traffic among the remaining routable subnets.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DetachLoadBalancerFromSubnets.sample
     */
    override suspend fun detachLoadBalancerFromSubnets(input: DetachLoadBalancerFromSubnetsRequest): DetachLoadBalancerFromSubnetsResponse {
        val op = SdkHttpOperation.build<DetachLoadBalancerFromSubnetsRequest, DetachLoadBalancerFromSubnetsResponse> {
            serializeWith = DetachLoadBalancerFromSubnetsOperationSerializer()
            deserializeWith = DetachLoadBalancerFromSubnetsOperationDeserializer()
            operationName = "DetachLoadBalancerFromSubnets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
     *
     * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
     *
     * There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the `OutOfService` state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.
     *
     * For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.DisableAvailabilityZonesForLoadBalancer.sample
     */
    override suspend fun disableAvailabilityZonesForLoadBalancer(input: DisableAvailabilityZonesForLoadBalancerRequest): DisableAvailabilityZonesForLoadBalancerResponse {
        val op = SdkHttpOperation.build<DisableAvailabilityZonesForLoadBalancerRequest, DisableAvailabilityZonesForLoadBalancerResponse> {
            serializeWith = DisableAvailabilityZonesForLoadBalancerOperationSerializer()
            deserializeWith = DisableAvailabilityZonesForLoadBalancerOperationDeserializer()
            operationName = "DisableAvailabilityZonesForLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
     *
     * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
     *
     * The load balancer evenly distributes requests across all its registered Availability Zones that contain instances. For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.EnableAvailabilityZonesForLoadBalancer.sample
     */
    override suspend fun enableAvailabilityZonesForLoadBalancer(input: EnableAvailabilityZonesForLoadBalancerRequest): EnableAvailabilityZonesForLoadBalancerResponse {
        val op = SdkHttpOperation.build<EnableAvailabilityZonesForLoadBalancerRequest, EnableAvailabilityZonesForLoadBalancerResponse> {
            serializeWith = EnableAvailabilityZonesForLoadBalancerOperationSerializer()
            deserializeWith = EnableAvailabilityZonesForLoadBalancerOperationDeserializer()
            operationName = "EnableAvailabilityZonesForLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the attributes of the specified load balancer.
     *
     * You can modify the load balancer attributes, such as `AccessLogs`, `ConnectionDraining`, and `CrossZoneLoadBalancing` by either enabling or disabling them. Or, you can modify the load balancer attribute `ConnectionSettings` by specifying an idle connection timeout value for your load balancer.
     *
     * For more information, see the following in the *Classic Load Balancers Guide*:
     * + [Cross-Zone Load Balancing](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html)
     * + [Connection Draining](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html)
     * + [Access Logs](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html)
     * + [Idle Connection Timeout](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html)
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.ModifyLoadBalancerAttributes.sample
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.ModifyLoadBalancerAttributes.sample2
     */
    override suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse> {
            serializeWith = ModifyLoadBalancerAttributesOperationSerializer()
            deserializeWith = ModifyLoadBalancerAttributesOperationDeserializer()
            operationName = "ModifyLoadBalancerAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified instances to the specified load balancer.
     *
     * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
     *
     * Note that `RegisterInstanceWithLoadBalancer` completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use DescribeLoadBalancers or DescribeInstanceHealth.
     *
     * After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the `OutOfService` state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the `InService` state.
     *
     * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
     *
     * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.RegisterInstancesWithLoadBalancer.sample
     */
    override suspend fun registerInstancesWithLoadBalancer(input: RegisterInstancesWithLoadBalancerRequest): RegisterInstancesWithLoadBalancerResponse {
        val op = SdkHttpOperation.build<RegisterInstancesWithLoadBalancerRequest, RegisterInstancesWithLoadBalancerResponse> {
            serializeWith = RegisterInstancesWithLoadBalancerOperationSerializer()
            deserializeWith = RegisterInstancesWithLoadBalancerOperationDeserializer()
            operationName = "RegisterInstancesWithLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified load balancer.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.RemoveTags.sample
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializeWith = RemoveTagsOperationSerializer()
            deserializeWith = RemoveTagsOperationDeserializer()
            operationName = "RemoveTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
     *
     * For more information about updating your SSL certificate, see [Replace the SSL Certificate for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.SetLoadBalancerListenerSSLCertificate.sample
     */
    override suspend fun setLoadBalancerListenerSslCertificate(input: SetLoadBalancerListenerSslCertificateRequest): SetLoadBalancerListenerSslCertificateResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerListenerSslCertificateRequest, SetLoadBalancerListenerSslCertificateResponse> {
            serializeWith = SetLoadBalancerListenerSSLCertificateOperationSerializer()
            deserializeWith = SetLoadBalancerListenerSSLCertificateOperationDeserializer()
            operationName = "SetLoadBalancerListenerSSLCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
     *
     * Each time you use `SetLoadBalancerPoliciesForBackendServer` to enable the policies, use the `PolicyNames` parameter to list the policies that you want to enable.
     *
     * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy is associated with the EC2 instance.
     *
     * For more information about enabling back-end instance authentication, see [Configure Back-end Instance Authentication](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt) in the *Classic Load Balancers Guide*. For more information about Proxy Protocol, see [Configure Proxy Protocol Support](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.SetLoadBalancerPoliciesForBackendServer.sample
     */
    override suspend fun setLoadBalancerPoliciesForBackendServer(input: SetLoadBalancerPoliciesForBackendServerRequest): SetLoadBalancerPoliciesForBackendServerResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerPoliciesForBackendServerRequest, SetLoadBalancerPoliciesForBackendServerResponse> {
            serializeWith = SetLoadBalancerPoliciesForBackendServerOperationSerializer()
            deserializeWith = SetLoadBalancerPoliciesForBackendServerOperationDeserializer()
            operationName = "SetLoadBalancerPoliciesForBackendServer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     *
     * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
     *
     * For more information about setting policies, see [Update the SSL Negotiation Configuration](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html), [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration), and [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
     *
     * @sample aws.sdk.kotlin.services.elasticloadbalancing.samples.SetLoadBalancerPoliciesOfListener.sample
     */
    override suspend fun setLoadBalancerPoliciesOfListener(input: SetLoadBalancerPoliciesOfListenerRequest): SetLoadBalancerPoliciesOfListenerResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerPoliciesOfListenerRequest, SetLoadBalancerPoliciesOfListenerResponse> {
            serializeWith = SetLoadBalancerPoliciesOfListenerOperationSerializer()
            deserializeWith = SetLoadBalancerPoliciesOfListenerOperationDeserializer()
            operationName = "SetLoadBalancerPoliciesOfListener"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elasticloadbalancing")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
