// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeLoadBalancerDescriptionDocument(reader: XmlTagReader): LoadBalancerDescription {
    val builder = LoadBalancerDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // LoadBalancerName com.amazonaws.elasticloadbalancing#LoadBalancerDescription$LoadBalancerName
            "LoadBalancerName" -> builder.loadBalancerName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#AccessPointName`)" }
            // DNSName com.amazonaws.elasticloadbalancing#LoadBalancerDescription$DNSName
            "DNSName" -> builder.dnsName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#DNSName`)" }
            // CanonicalHostedZoneName com.amazonaws.elasticloadbalancing#LoadBalancerDescription$CanonicalHostedZoneName
            "CanonicalHostedZoneName" -> builder.canonicalHostedZoneName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#DNSName`)" }
            // CanonicalHostedZoneNameID com.amazonaws.elasticloadbalancing#LoadBalancerDescription$CanonicalHostedZoneNameID
            "CanonicalHostedZoneNameID" -> builder.canonicalHostedZoneNameId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#DNSName`)" }
            // ListenerDescriptions com.amazonaws.elasticloadbalancing#LoadBalancerDescription$ListenerDescriptions
            "ListenerDescriptions" -> builder.listenerDescriptions = deserializeListenerDescriptionsShape(curr)
            // Policies com.amazonaws.elasticloadbalancing#LoadBalancerDescription$Policies
            "Policies" -> builder.policies = deserializePoliciesDocument(curr)
            // BackendServerDescriptions com.amazonaws.elasticloadbalancing#LoadBalancerDescription$BackendServerDescriptions
            "BackendServerDescriptions" -> builder.backendServerDescriptions = deserializeBackendServerDescriptionsShape(curr)
            // AvailabilityZones com.amazonaws.elasticloadbalancing#LoadBalancerDescription$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // Subnets com.amazonaws.elasticloadbalancing#LoadBalancerDescription$Subnets
            "Subnets" -> builder.subnets = deserializeSubnetsShape(curr)
            // VPCId com.amazonaws.elasticloadbalancing#LoadBalancerDescription$VPCId
            "VPCId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#VPCId`)" }
            // Instances com.amazonaws.elasticloadbalancing#LoadBalancerDescription$Instances
            "Instances" -> builder.instances = deserializeInstancesShape(curr)
            // HealthCheck com.amazonaws.elasticloadbalancing#LoadBalancerDescription$HealthCheck
            "HealthCheck" -> builder.healthCheck = deserializeHealthCheckDocument(curr)
            // SourceSecurityGroup com.amazonaws.elasticloadbalancing#LoadBalancerDescription$SourceSecurityGroup
            "SourceSecurityGroup" -> builder.sourceSecurityGroup = deserializeSourceSecurityGroupDocument(curr)
            // SecurityGroups com.amazonaws.elasticloadbalancing#LoadBalancerDescription$SecurityGroups
            "SecurityGroups" -> builder.securityGroups = deserializeSecurityGroupsShape(curr)
            // CreatedTime com.amazonaws.elasticloadbalancing#LoadBalancerDescription$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticloadbalancing#CreatedTime`)" }
            // Scheme com.amazonaws.elasticloadbalancing#LoadBalancerDescription$Scheme
            "Scheme" -> builder.scheme = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#LoadBalancerScheme`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
