// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.Limit
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeAccountLimitsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAccountLimitsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAccountLimitsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAccountLimitsError(context, call, payload)
        }
        val builder = DescribeAccountLimitsResponse.Builder()

        if (payload != null) {
            deserializeDescribeAccountLimitsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAccountLimitsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountLimitsOperationBody(builder: DescribeAccountLimitsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeAccountLimits")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Limits com.amazonaws.elasticloadbalancing#DescribeAccountLimitsOutput$Limits
            "Limits" -> builder.limits = deserializeLimitsShape(curr)
            // NextMarker com.amazonaws.elasticloadbalancing#DescribeAccountLimitsOutput$NextMarker
            "NextMarker" -> builder.nextMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#Marker`)" }
            else -> {}
        }
        curr.drop()
    }
}
