// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateLoadBalancerOperationDeserializer: HttpDeserializer.NonStreaming<CreateLoadBalancerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateLoadBalancerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLoadBalancerError(context, call, payload)
        }
        val builder = CreateLoadBalancerResponse.Builder()

        if (payload != null) {
            deserializeCreateLoadBalancerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateLoadBalancerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidScheme" -> InvalidSchemeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SubnetNotFound" -> SubnetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyLoadBalancers" -> TooManyAccessPointsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurityGroup" -> InvalidSecurityGroupExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermitted" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTags" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateTagKeys" -> DuplicateTagKeysExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateLoadBalancerName" -> DuplicateAccessPointNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLoadBalancerOperationBody(builder: CreateLoadBalancerResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateLoadBalancer")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DNSName com.amazonaws.elasticloadbalancing#CreateAccessPointOutput$DNSName
            "DNSName" -> builder.dnsName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticloadbalancing#DNSName`)" }
            else -> {}
        }
        curr.drop()
    }
}
