// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeInstanceHealthOperationDeserializer: HttpDeserialize<DescribeInstanceHealthResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeInstanceHealthResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeInstanceHealthError(context, call)
        }
        val builder = DescribeInstanceHealthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInstanceHealthOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeInstanceHealthError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInstance" -> InvalidEndPointExceptionDeserializer().deserialize(context, wrappedCall)
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInstanceHealthOperationBody(builder: DescribeInstanceHealthResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeInstanceHealthResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeInstanceHealthResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeInstanceHealth response")
    }
    // end unwrap response wrapper

    val INSTANCESTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("InstanceStates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2012-06-01/"))
        trait(XmlSerialName("DescribeInstanceHealthResult"))
        field(INSTANCESTATES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCESTATES_DESCRIPTOR.index -> builder.instanceStates =
                    deserializer.deserializeList(INSTANCESTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
