// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateLoadBalancerOperationDeserializer: HttpDeserialize<CreateLoadBalancerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateLoadBalancerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLoadBalancerError(context, call)
        }
        val builder = CreateLoadBalancerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLoadBalancerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateLoadBalancerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidScheme" -> InvalidSchemeExceptionDeserializer().deserialize(context, wrappedCall)
        "SubnetNotFound" -> SubnetNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyLoadBalancers" -> TooManyAccessPointsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSecurityGroup" -> InvalidSecurityGroupExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermitted" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyTags" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedCall)
        "DuplicateTagKeys" -> DuplicateTagKeysExceptionDeserializer().deserialize(context, wrappedCall)
        "DuplicateLoadBalancerName" -> DuplicateAccessPointNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLoadBalancerOperationBody(builder: CreateLoadBalancerResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateLoadBalancerResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateLoadBalancerResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateLoadBalancer response")
    }
    // end unwrap response wrapper

    val DNSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DNSName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2012-06-01/"))
        trait(XmlSerialName("CreateLoadBalancerResult"))
        field(DNSNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DNSNAME_DESCRIPTOR.index -> builder.dnsName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
