// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateAppCookieStickinessPolicyOperationDeserializer: HttpDeserialize<CreateAppCookieStickinessPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAppCookieStickinessPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAppCookieStickinessPolicyError(context, call)
        }
        val builder = CreateAppCookieStickinessPolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAppCookieStickinessPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyPolicies" -> TooManyPoliciesExceptionDeserializer().deserialize(context, wrappedCall)
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DuplicatePolicyName" -> DuplicatePolicyNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
