// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model



/**
 * Information about the state of an EC2 instance.
 */
public class InstanceState private constructor(builder: Builder) {
    /**
     * A description of the instance state. This string can contain one or more of the following messages.
     * + `N/A`
     * + `A transient error occurred. Please try again later.`
     * + `Instance has failed at least the UnhealthyThreshold number of health checks consecutively.`
     * + `Instance has not passed the configured HealthyThreshold number of health checks consecutively.`
     * + `Instance registration is still in progress.`
     * + `Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.`
     * + `Instance is not currently registered with the LoadBalancer.`
     * + `Instance deregistration currently in progress.`
     * + `Disable Availability Zone is currently in progress.`
     * + `Instance is in pending state.`
     * + `Instance is in stopped state.`
     * + `Instance is in terminated state.`
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Information about the cause of `OutOfService` instances. Specifically, whether the cause is Elastic Load Balancing or the instance.
     *
     * Valid values: `ELB` | `Instance` | `N/A`
     */
    public val reasonCode: kotlin.String? = builder.reasonCode
    /**
     * The current state of the instance.
     *
     * Valid values: `InService` | `OutOfService` | `Unknown`
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceState(")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("reasonCode=$reasonCode,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (reasonCode?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceState

        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (reasonCode != other.reasonCode) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the instance state. This string can contain one or more of the following messages.
         * + `N/A`
         * + `A transient error occurred. Please try again later.`
         * + `Instance has failed at least the UnhealthyThreshold number of health checks consecutively.`
         * + `Instance has not passed the configured HealthyThreshold number of health checks consecutively.`
         * + `Instance registration is still in progress.`
         * + `Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.`
         * + `Instance is not currently registered with the LoadBalancer.`
         * + `Instance deregistration currently in progress.`
         * + `Disable Availability Zone is currently in progress.`
         * + `Instance is in pending state.`
         * + `Instance is in stopped state.`
         * + `Instance is in terminated state.`
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Information about the cause of `OutOfService` instances. Specifically, whether the cause is Elastic Load Balancing or the instance.
         *
         * Valid values: `ELB` | `Instance` | `N/A`
         */
        public var reasonCode: kotlin.String? = null
        /**
         * The current state of the instance.
         *
         * Valid values: `InService` | `OutOfService` | `Unknown`
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState) : this() {
            this.description = x.description
            this.instanceId = x.instanceId
            this.reasonCode = x.reasonCode
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState = InstanceState(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
