// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model



/**
 * Contains the parameters for CreateLoadBalancer.
 */
public class CreateLoadBalancerRequest private constructor(builder: Builder) {
    /**
     * One or more Availability Zones from the same region as the load balancer.
     *
     * You must specify at least one Availability Zone.
     *
     * You can add more Availability Zones after you create the load balancer using EnableAvailabilityZonesForLoadBalancer.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The listeners.
     *
     * For more information, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
     */
    public val listeners: List<Listener>? = builder.listeners
    /**
     * The name of the load balancer.
     *
     * This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The type of a load balancer. Valid only for load balancers in a VPC.
     *
     * By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see [Load Balancer Scheme](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme) in the *Elastic Load Balancing User Guide*.
     *
     * Specify `internal` to create a load balancer with a DNS name that resolves to private IP addresses.
     */
    public val scheme: kotlin.String? = builder.scheme
    /**
     * The IDs of the security groups to assign to the load balancer.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in `AvailabilityZones`.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * A list of tags to assign to the load balancer.
     *
     * For more information about tagging your load balancer, see [Tag Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html) in the *Classic Load Balancers Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLoadBalancerRequest(")
        append("availabilityZones=$availabilityZones,")
        append("listeners=$listeners,")
        append("loadBalancerName=$loadBalancerName,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("subnets=$subnets,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (listeners?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLoadBalancerRequest

        if (availabilityZones != other.availabilityZones) return false
        if (listeners != other.listeners) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more Availability Zones from the same region as the load balancer.
         *
         * You must specify at least one Availability Zone.
         *
         * You can add more Availability Zones after you create the load balancer using EnableAvailabilityZonesForLoadBalancer.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The listeners.
         *
         * For more information, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
         */
        public var listeners: List<Listener>? = null
        /**
         * The name of the load balancer.
         *
         * This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The type of a load balancer. Valid only for load balancers in a VPC.
         *
         * By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see [Load Balancer Scheme](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme) in the *Elastic Load Balancing User Guide*.
         *
         * Specify `internal` to create a load balancer with a DNS name that resolves to private IP addresses.
         */
        public var scheme: kotlin.String? = null
        /**
         * The IDs of the security groups to assign to the load balancer.
         */
        public var securityGroups: List<String>? = null
        /**
         * The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in `AvailabilityZones`.
         */
        public var subnets: List<String>? = null
        /**
         * A list of tags to assign to the load balancer.
         *
         * For more information about tagging your load balancer, see [Tag Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html) in the *Classic Load Balancers Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.listeners = x.listeners
            this.loadBalancerName = x.loadBalancerName
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.subnets = x.subnets
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerRequest = CreateLoadBalancerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
