// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.waiters

import aws.sdk.kotlin.services.elasticloadbalancing.ElasticLoadBalancingClient
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun ElasticLoadBalancingClient.waitUntilAnyInstanceInService(request: DescribeInstanceHealthRequest): Outcome<DescribeInstanceHealthResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStates = it.instanceStates
            val instanceStatesOrEmpty = instanceStates?.flattenIfPossible()
            val projection = instanceStatesOrEmpty?.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            (projection as List<String?>?)?.any { it == "InService" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceHealth(request) }
}

public suspend fun ElasticLoadBalancingClient.waitUntilAnyInstanceInService(block: DescribeInstanceHealthRequest.Builder.() -> Unit): Outcome<DescribeInstanceHealthResponse> =
    waitUntilAnyInstanceInService(DescribeInstanceHealthRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingClient.waitUntilInstanceDeregistered(request: DescribeInstanceHealthRequest): Outcome<DescribeInstanceHealthResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStates = it.instanceStates
            val instanceStatesOrEmpty = instanceStates?.flattenIfPossible()
            val projection = instanceStatesOrEmpty?.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "OutOfService" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "InvalidInstance"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceHealth(request) }
}

public suspend fun ElasticLoadBalancingClient.waitUntilInstanceDeregistered(block: DescribeInstanceHealthRequest.Builder.() -> Unit): Outcome<DescribeInstanceHealthResponse> =
    waitUntilInstanceDeregistered(DescribeInstanceHealthRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingClient.waitUntilInstanceInService(request: DescribeInstanceHealthRequest): Outcome<DescribeInstanceHealthResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStates = it.instanceStates
            val instanceStatesOrEmpty = instanceStates?.flattenIfPossible()
            val projection = instanceStatesOrEmpty?.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "InService" }
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInstance"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceHealth(request) }
}

public suspend fun ElasticLoadBalancingClient.waitUntilInstanceInService(block: DescribeInstanceHealthRequest.Builder.() -> Unit): Outcome<DescribeInstanceHealthResponse> =
    waitUntilInstanceInService(DescribeInstanceHealthRequest.Builder().apply(block).build())
