// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.serde

import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class SetLoadBalancerPoliciesOfListenerOperationDeserializer: HttpDeserialize<SetLoadBalancerPoliciesOfListenerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SetLoadBalancerPoliciesOfListenerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetLoadBalancerPoliciesOfListenerError(context, call)
        }
        val builder = SetLoadBalancerPoliciesOfListenerResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSetLoadBalancerPoliciesOfListenerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "PolicyNotFound" -> PolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
