// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model



/**
 * Information about a health check.
 */
public class HealthCheck private constructor(builder: Builder) {
    /**
     * The number of consecutive health checks successes required before moving the instance to the `Healthy` state.
     */
    public val healthyThreshold: kotlin.Int = requireNotNull(builder.healthyThreshold) { "A non-null value must be provided for healthyThreshold" }
    /**
     * The approximate interval, in seconds, between health checks of an individual instance.
     */
    public val interval: kotlin.Int = requireNotNull(builder.interval) { "A non-null value must be provided for interval" }
    /**
     * The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.
     *
     * TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.
     *
     * SSL is also specified as SSL: port pair, for example, SSL:5000.
     *
     * For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.
     *
     * The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
     */
    public val target: kotlin.String = requireNotNull(builder.target) { "A non-null value must be provided for target" }
    /**
     * The amount of time, in seconds, during which no response means a failed health check.
     *
     * This value must be less than the `Interval` value.
     */
    public val timeout: kotlin.Int = requireNotNull(builder.timeout) { "A non-null value must be provided for timeout" }
    /**
     * The number of consecutive health check failures required before moving the instance to the `Unhealthy` state.
     */
    public val unhealthyThreshold: kotlin.Int = requireNotNull(builder.unhealthyThreshold) { "A non-null value must be provided for unhealthyThreshold" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheck(")
        append("healthyThreshold=$healthyThreshold,")
        append("interval=$interval,")
        append("target=$target,")
        append("timeout=$timeout,")
        append("unhealthyThreshold=$unhealthyThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold
        result = 31 * result + (interval)
        result = 31 * result + (target.hashCode())
        result = 31 * result + (timeout)
        result = 31 * result + (unhealthyThreshold)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheck

        if (healthyThreshold != other.healthyThreshold) return false
        if (interval != other.interval) return false
        if (target != other.target) return false
        if (timeout != other.timeout) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of consecutive health checks successes required before moving the instance to the `Healthy` state.
         */
        public var healthyThreshold: kotlin.Int? = null
        /**
         * The approximate interval, in seconds, between health checks of an individual instance.
         */
        public var interval: kotlin.Int? = null
        /**
         * The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.
         *
         * TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.
         *
         * SSL is also specified as SSL: port pair, for example, SSL:5000.
         *
         * For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.
         *
         * The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
         */
        public var target: kotlin.String? = null
        /**
         * The amount of time, in seconds, during which no response means a failed health check.
         *
         * This value must be less than the `Interval` value.
         */
        public var timeout: kotlin.Int? = null
        /**
         * The number of consecutive health check failures required before moving the instance to the `Unhealthy` state.
         */
        public var unhealthyThreshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.interval = x.interval
            this.target = x.target
            this.timeout = x.timeout
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.HealthCheck = HealthCheck(this)

        internal fun correctErrors(): Builder {
            if (healthyThreshold == null) healthyThreshold = 0
            if (interval == null) interval = 0
            if (target == null) target = ""
            if (timeout == null) timeout = 0
            if (unhealthyThreshold == null) unhealthyThreshold = 0
            return this
        }
    }
}
