// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticinference.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorsResponse
import aws.sdk.kotlin.services.elasticinference.model.ElasticInferenceAccelerator
import aws.sdk.kotlin.services.elasticinference.model.ElasticInferenceException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeAcceleratorsOperationDeserializer: HttpDeserialize<DescribeAcceleratorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAcceleratorsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAcceleratorsError(context, response)
        }
        val builder = DescribeAcceleratorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAcceleratorsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAcceleratorsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticInferenceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticInferenceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAcceleratorsOperationBody(builder: DescribeAcceleratorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCELERATORSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("acceleratorSet"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCELERATORSET_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCELERATORSET_DESCRIPTOR.index -> builder.acceleratorSet =
                    deserializer.deserializeList(ACCELERATORSET_DESCRIPTOR) {
                        val col0 = mutableListOf<ElasticInferenceAccelerator>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeElasticInferenceAcceleratorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
