// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticinference

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.services.elasticinference.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.elasticinference.endpoints.EndpointProvider
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorTypesRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorTypesResponse
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorsRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorsResponse
import aws.sdk.kotlin.services.elasticinference.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticinference.model.TagResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.TagResourceResponse
import aws.sdk.kotlin.services.elasticinference.model.UntagResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Elastic Inference public APIs.
 */
public interface ElasticInferenceClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Inference"
    /**
     * ElasticInferenceClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ElasticInferenceClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ElasticInferenceClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ElasticInferenceClient = DefaultElasticInferenceClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Elastic Inference")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Describes the locations in which a given accelerator type or set of types is present in a given region.
     */
    public suspend fun describeAcceleratorOfferings(input: DescribeAcceleratorOfferingsRequest): DescribeAcceleratorOfferingsResponse

    /**
     * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
     */
    public suspend fun describeAcceleratorTypes(input: DescribeAcceleratorTypesRequest = DescribeAcceleratorTypesRequest {}): DescribeAcceleratorTypesResponse

    /**
     * Describes information over a provided set of accelerators belonging to an account.
     */
    public suspend fun describeAccelerators(input: DescribeAcceleratorsRequest = DescribeAcceleratorsRequest {}): DescribeAcceleratorsResponse

    /**
     * Returns all tags of an Elastic Inference Accelerator.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds the specified tags to an Elastic Inference Accelerator.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from an Elastic Inference Accelerator.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ElasticInferenceClient.withConfig(block: ElasticInferenceClient.Config.Builder.() -> Unit): ElasticInferenceClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultElasticInferenceClient(newConfig)
}

/**
 * Describes the locations in which a given accelerator type or set of types is present in a given region.
 */
public suspend inline fun ElasticInferenceClient.describeAcceleratorOfferings(crossinline block: DescribeAcceleratorOfferingsRequest.Builder.() -> Unit): DescribeAcceleratorOfferingsResponse = describeAcceleratorOfferings(DescribeAcceleratorOfferingsRequest.Builder().apply(block).build())

/**
 * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
 */
public suspend inline fun ElasticInferenceClient.describeAcceleratorTypes(crossinline block: DescribeAcceleratorTypesRequest.Builder.() -> Unit): DescribeAcceleratorTypesResponse = describeAcceleratorTypes(DescribeAcceleratorTypesRequest.Builder().apply(block).build())

/**
 * Describes information over a provided set of accelerators belonging to an account.
 */
public suspend inline fun ElasticInferenceClient.describeAccelerators(crossinline block: DescribeAcceleratorsRequest.Builder.() -> Unit): DescribeAcceleratorsResponse = describeAccelerators(DescribeAcceleratorsRequest.Builder().apply(block).build())

/**
 * Returns all tags of an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
