// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.SwapEnvironmentCnamEsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class SwapEnvironmentCNAMEsOperationDeserializer: HttpDeserialize<SwapEnvironmentCnamEsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SwapEnvironmentCnamEsResponse {
        if (!response.status.isSuccess()) {
            throwSwapEnvironmentCnamEsError(context, response)
        }
        val builder = SwapEnvironmentCnamEsResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwSwapEnvironmentCnamEsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw ElasticBeanstalkException(errorDetails.message)
}
