// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeEventsOperationSerializer: HttpSerialize<DescribeEventsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DescribeEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDescribeEventsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeDescribeEventsOperationBody(context: ExecutionContext, input: DescribeEventsRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ApplicationName"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("EndTime"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EnvironmentId"))
    val ENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EnvironmentName"))
    val MAXRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxRecords"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NextToken"))
    val PLATFORMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PlatformArn"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RequestId"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Severity"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("StartTime"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateName"))
    val VERSIONLABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("VersionLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("DescribeEventsMessage"))
        trait(QueryLiteral("Action", "DescribeEvents"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(APPLICATIONNAME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ENVIRONMENTNAME_DESCRIPTOR)
        field(MAXRECORDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PLATFORMARN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
        field(VERSIONLABEL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationName?.let { field(APPLICATIONNAME_DESCRIPTOR, it) }
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.environmentId?.let { field(ENVIRONMENTID_DESCRIPTOR, it) }
        input.environmentName?.let { field(ENVIRONMENTNAME_DESCRIPTOR, it) }
        input.maxRecords?.let { field(MAXRECORDS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.platformArn?.let { field(PLATFORMARN_DESCRIPTOR, it) }
        input.requestId?.let { field(REQUESTID_DESCRIPTOR, it) }
        input.severity?.let { field(SEVERITY_DESCRIPTOR, it.value) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.templateName?.let { field(TEMPLATENAME_DESCRIPTOR, it) }
        input.versionLabel?.let { field(VERSIONLABEL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
