// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreatePlatformVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreatePlatformVersionOperationDeserializer: HttpDeserialize<CreatePlatformVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePlatformVersionResponse {
        if (!response.status.isSuccess()) {
            throwCreatePlatformVersionError(context, response)
        }
        val builder = CreatePlatformVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePlatformVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreatePlatformVersionOperationBody(builder: CreatePlatformVersionResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreatePlatformVersionResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreatePlatformVersionResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreatePlatformVersion response")
    }

    val BUILDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Builder"))
    val PLATFORMSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PlatformSummary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("CreatePlatformVersionResult"))
        field(BUILDER_DESCRIPTOR)
        field(PLATFORMSUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUILDER_DESCRIPTOR.index -> builder.builder = deserializeBuilderDocument(deserializer)
                PLATFORMSUMMARY_DESCRIPTOR.index -> builder.platformSummary = deserializePlatformSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreatePlatformVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ElasticBeanstalkServiceException" -> ElasticBeanstalkServiceExceptionDeserializer()
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer()
        "TooManyPlatformsException" -> TooManyPlatformsExceptionDeserializer()
        else -> throw ElasticBeanstalkException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
