// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateConfigurationTemplateOperationDeserializer: HttpDeserialize<CreateConfigurationTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateConfigurationTemplateResponse {
        if (!response.status.isSuccess()) {
            throwCreateConfigurationTemplateError(context, response)
        }
        val builder = CreateConfigurationTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateConfigurationTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateConfigurationTemplateOperationBody(builder: CreateConfigurationTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateConfigurationTemplateResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateConfigurationTemplateResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateConfigurationTemplate response")
    }

    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ApplicationName"))
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("DateCreated"))
    val DATEUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("DateUpdated"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DeploymentStatus"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val ENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EnvironmentName"))
    val OPTIONSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("OptionSettings"))
    val PLATFORMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PlatformArn"))
    val SOLUTIONSTACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SolutionStackName"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TemplateName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("CreateConfigurationTemplateResult"))
        field(APPLICATIONNAME_DESCRIPTOR)
        field(DATECREATED_DESCRIPTOR)
        field(DATEUPDATED_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENTNAME_DESCRIPTOR)
        field(OPTIONSETTINGS_DESCRIPTOR)
        field(PLATFORMARN_DESCRIPTOR)
        field(SOLUTIONSTACKNAME_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeString().let { Instant.fromIso8601(it) }
                DATEUPDATED_DESCRIPTOR.index -> builder.dateUpdated = deserializeString().let { Instant.fromIso8601(it) }
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString().let { ConfigurationDeploymentStatus.fromValue(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENTNAME_DESCRIPTOR.index -> builder.environmentName = deserializeString()
                OPTIONSETTINGS_DESCRIPTOR.index -> builder.optionSettings =
                    deserializer.deserializeList(OPTIONSETTINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ConfigurationOptionSetting>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConfigurationOptionSettingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PLATFORMARN_DESCRIPTOR.index -> builder.platformArn = deserializeString()
                SOLUTIONSTACKNAME_DESCRIPTOR.index -> builder.solutionStackName = deserializeString()
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateConfigurationTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer()
        "TooManyBucketsException" -> TooManyBucketsExceptionDeserializer()
        "TooManyConfigurationTemplatesException" -> TooManyConfigurationTemplatesExceptionDeserializer()
        else -> throw ElasticBeanstalkException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
