// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AssociateEnvironmentOperationsRoleOperationDeserializer: HttpDeserialize<AssociateEnvironmentOperationsRoleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateEnvironmentOperationsRoleResponse {
        if (!response.status.isSuccess()) {
            throwAssociateEnvironmentOperationsRoleError(context, response)
        }
        val builder = AssociateEnvironmentOperationsRoleResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAssociateEnvironmentOperationsRoleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer()
        else -> throw ElasticBeanstalkException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
