// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the settings for a configuration set.
 */
class UpdateConfigurationTemplateResponse private constructor(builder: Builder) {
    /**
     * The name of the application associated with this configuration set.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The date (in UTC time) when this configuration set was created.
     */
    val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date (in UTC time) when this configuration set was last modified.
     */
    val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * If this configuration set is associated with an environment, the
     * DeploymentStatus parameter indicates the deployment status of this
     * configuration set:
     * null: This configuration is not associated with a running
     * environment.
     * pending: This is a draft configuration that is not deployed to the associated
     * environment but is in the process of deploying.
     * deployed: This is the configuration that is currently deployed to the
     * associated running environment.
     * failed: This is a draft configuration that failed to successfully
     * deploy.
     */
    val deploymentStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus? = builder.deploymentStatus
    /**
     * Describes this configuration set.
     */
    val description: kotlin.String? = builder.description
    /**
     * If not null, the name of the environment for this configuration set.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * A list of the configuration options and their values in this configuration
     * set.
     */
    val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * The ARN of the platform version.
     */
    val platformArn: kotlin.String? = builder.platformArn
    /**
     * The name of the solution stack this configuration set uses.
     */
    val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * If not null, the name of the configuration template for this
     * configuration set.
     */
    val templateName: kotlin.String? = builder.templateName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationTemplateResponse(")
        append("applicationName=$applicationName,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("deploymentStatus=$deploymentStatus,")
        append("description=$description,")
        append("environmentName=$environmentName,")
        append("optionSettings=$optionSettings,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateConfigurationTemplateResponse

        if (applicationName != other.applicationName) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (description != other.description) return false
        if (environmentName != other.environmentName) return false
        if (optionSettings != other.optionSettings) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (templateName != other.templateName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application associated with this configuration set.
         */
        var applicationName: kotlin.String? = null
        /**
         * The date (in UTC time) when this configuration set was created.
         */
        var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date (in UTC time) when this configuration set was last modified.
         */
        var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If this configuration set is associated with an environment, the
         * DeploymentStatus parameter indicates the deployment status of this
         * configuration set:
         * null: This configuration is not associated with a running
         * environment.
         * pending: This is a draft configuration that is not deployed to the associated
         * environment but is in the process of deploying.
         * deployed: This is the configuration that is currently deployed to the
         * associated running environment.
         * failed: This is a draft configuration that failed to successfully
         * deploy.
         */
        var deploymentStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus? = null
        /**
         * Describes this configuration set.
         */
        var description: kotlin.String? = null
        /**
         * If not null, the name of the environment for this configuration set.
         */
        var environmentName: kotlin.String? = null
        /**
         * A list of the configuration options and their values in this configuration
         * set.
         */
        var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * The ARN of the platform version.
         */
        var platformArn: kotlin.String? = null
        /**
         * The name of the solution stack this configuration set uses.
         */
        var solutionStackName: kotlin.String? = null
        /**
         * If not null, the name of the configuration template for this
         * configuration set.
         */
        var templateName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse) : this() {
            this.applicationName = x.applicationName
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.deploymentStatus = x.deploymentStatus
            this.description = x.description
            this.environmentName = x.environmentName
            this.optionSettings = x.optionSettings
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse = UpdateConfigurationTemplateResponse(this)
    }
}
